%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This work by EPFL STI IBI LBNI is licensed under 
% a Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
% Based on a work at http://lbni.epfl.ch/.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%try
%% Clear Variables.  Turn off Obnoxious warnings...
%Image Filename and path
warning('off','MATLAB:MKDIR:DirectoryExists');                                                                                 % Elliminates warning that the directory being made already exists
warning('off','MATLAB:nearlySingularMatrix');                                                                                   % Your fit sucked.  Turns off the warning
warning('off','MATLAB:polyfit:PolyNotUnique');                                                                                  % Fit still sucked.  Turns off the warning
warning('off','Images:initSize:adjustingMag');                                                                                  % Image was too big to display on the screen. Matlab resized it.  Turns the warning off.
warning('off','curvefit:fit:equationBadlyConditioned');                                                                         % Your fit sucked.  Turns off the warning
warning('off','curvefit:prepareSurfaceData:removingNaNAndInf');                                                                 % NaN's in the thresholded data.  Turns off the warning
warning('off','curvefit:prepareSurfaceData:swapXAndYForTable');                                                                 % Image isn't square.  Turns off the warning
warning('off','MATLAB:MKDIR:DirectoryExists');

%% Set relevant input paramters.  Scalebar sizes, fitting limits and so forth

FontSize                    = 13;                                                                                              % Font Size for images
FontName                    = 'Arial';                                                                                          % Font for images
amplitude_fract             = 0.2;                                                                                             % Amplitude variability for fitting histogramed peaks to determine thresholds
    

histogram_bins              = str2double(get(S.histogram_bins, 'string'));
smoothing_level             = str2double(get(S.smoothing_level, 'string'));
thresh_range                = str2double(get(S.thresh_range, 'string'));                                                                                       
peak_threshold              = str2double(get(S.peak_threshold, 'string'));
crop_fraction               = str2double(get(S.crop_fraction, 'string'));
ScaleBar                    = str2double(get(S.scale_bar_length, 'string'));


Med_corr                 = zeros(1,15);
Med_corr_2               = zeros(1,15);
vert_med_corr            = zeros(1,15);
poly_order_horiz         = zeros(1,15);              
poly_order_vert          = zeros(1,15);
z_height_reference       = zeros(1,15);
min_spacing_stdev_user   = zeros(1,15);        
max_spacing_stdev_user   = zeros(1,15);
min_z                    = zeros(1,15);
max_z                    = zeros(1,15);
peaks_fit                = zeros(1,15);
peak_reference_height    = zeros(1,15);
peak_to_flatten          = zeros(1,15); 
Calc_flatten_lim         = zeros(1,15);
SymZLim                  = zeros(1,15);
overwrite_xlim           = zeros(1,15);
sort_peaks               = zeros(1,15);
min_peak_height_ref      = zeros(1,15);                                                          
min_peak_distance_ref    = zeros(1,15);

for k = 1:15
    Med_corr(k)                 = get(S.Med_corr(k), 'value');
    Med_corr_2(k)               = get(S.Med_corr_2(k), 'value');
    vert_med_corr(k)            = get(S.vert_med_corr(k), 'value');
    poly_order_horiz(k)         = get(S.poly_order_horiz(k), 'value')-1;              
    poly_order_vert(k)          = get(S.poly_order_vert(k), 'value')-1;
    z_height_reference(k)       = str2double(get(S.z_height_reference(k), 'string'));
    min_spacing_stdev_user(k)   = str2double(get(S.min_spacing_stdev_user(k), 'string'));        
    max_spacing_stdev_user(k)   = str2double(get(S.max_spacing_stdev_user(k), 'string'));
    min_z(k)                    = str2double(get(S.min_z(k), 'string'));
    max_z(k)                    = str2double(get(S.max_z(k), 'string'));
    peaks_fit(k)                = get(S.peaks_fit(k), 'value');
    peak_reference_height(k)    = get(S.peak_reference_height(k), 'value');
    peak_to_flatten(k)          = get(S.peak_to_flatten(k), 'value'); 
    Calc_flatten_lim(k)         = get(S.Calc_flatten_lim(k), 'value');
    SymZLim(k)                  = get(S.SymZLim(k), 'value');
    overwrite_xlim(k)           = get(S.overwrite_xlim(k), 'value');
    sort_peaks(k)               = get(S.sort_peaks(k), 'value');
    min_peak_height_ref(k)      = str2double(get(S.min_peak_height(k), 'string'));                                                          
    min_peak_distance_ref(k)    = str2double(get(S.min_peak_distance(k), 'string')); 
end

Offset_data                 = zeros(15, 1);
fit_hist                    = zeros(15, 1);
%min_z                      = zeros(15, 1);
%max_z                      = zeros(15, 1);
for k                       = 1:15
     if z_height_reference(k) == 0
        Offset_data(k)      = 0;
     else
        Offset_data(k)      = 1;
     end
     if peaks_fit(k)        == 0
         fit_hist(k)        = 0;
     else
         fit_hist(k)        = 1;
     end
end

disp_percent                = 1; %'Yes';
percent_search              = [1 10 90 99];

sequential_flattening       = 0; %'1 turns this on';                                                                                               % If Y, the flattening is done sequentially; if N, the final mask is directly applied to the inital image after first median correction

plot_intermediate_steps     = 0; %'N';
plot_tilt_check             = 0; %'N';% To decide if the intermediate images and histograms at each step are plotted or not
plot_intermediate_image     = 0; %'N';                                                                                                  % To decide if the image and histogram after first median corr and global tilt corr are plotted or not

peak_pos_tolerance          = 5.0e-1;                                                                                               % Tolerance on the displacement of each peak from one step to the other for a good identification of each peak


%% Select Files to read
    ImageDir = get(S.selectFolderText, 'string');
    ImageDir = [ImageDir,filesep];
    Filename = get(S.selectFileText, 'string');
    if S.processAll  == 1        % Process all images
            Filename_length = length(Filename);
    else
              Filename_length = 1;
    end

%% Prep for file output
mkdir([ImageDir,get(S.baseDirectoryText,'string'),filesep,'Figure PNGS',filesep]);                                                                                       % Makes a new directory for the final jpeg output

%% Loop the import and processing routiene for the number of selected files
load('Sky','mycmap_sky')
load('NanoBrown','mycmap_nanobrown') 
    Init_poly_coef              = cell(length(Filename),15);
    Init_poly_coef_1st_med      = cell(length(Filename),15);
    Init_poly_coef_1st_nomed    = cell(length(Filename),15);
    Init_poly_coef_2nd_med      = cell(length(Filename),15);
    Init_poly_coef_2nd_nomed    = cell(length(Filename),15);
    Second_poly_coef            = cell(length(Filename),15);
    Third_poly_coef             = cell(length(Filename),15);
    min_spacing_stdev           = zeros(Filename_length,15);
    max_spacing_stdev           = zeros(Filename_length,15);

if S.processAll  == 0        % Process one image
    start_index = 1;  
else
    start_index = 2;
end

for index = start_index:Filename_length                                                                                               % Loops through the number of files
      
   file_name    = [ImageDir,Filename{index}];                                                                                     % Generates the filname to open for this particular iteration
   [  param,       scaling,         spl,             linno,         image_pos,...
      ScanSize,    Z_Sensitivity,   Z_Magnification, Scan_Rate,     Defl_Sens,...
      Drive_Freq,  Drive_Amp,       Amp_Set_Point,   Z_sensor_sens, Amp_sens,...
      SpringConst, AspectRatio,     Direction,       tok,           remain,...
      file_number, channel_info,    finalscaling,    images,        Time] = Import_file(ImageDir,get(S.baseDirectoryText,'string'), Filename,index,S,min_spacing_stdev_user,max_spacing_stdev_user);
        
        
    if S.processAll  == 0        % Process one image
       update_scrolltext([get(S.hText,'UserData');['Image ',num2str(index),' of 1']],S.hText,S.hSlider);
       pause(0.0001);
    else
       update_scrolltext({['Image ',num2str(index),' of ',num2str(length(Filename))]},S.hText,S.hSlider);
       pause(0.0001);
    end

%% Crop Images.  Helps deal with some of the turn around ripple
images                          = images(ceil(crop_fraction/2*size(images,1))+1:floor((1-crop_fraction/2)*size(images,1)),ceil(crop_fraction/2*size(images,2))+1:floor((1-crop_fraction/2)*size(images,2)),:);
if index<= 2
    all_images                  = zeros([Filename_length,size(images,1),size(images,2),15]);
    all_images_int              = zeros([Filename_length,size(images,1),size(images,2),15]);
end
%% This section actuall does all of the image processing.  Different blocks will be explained below  Code Loops through each of the channels and applies all of the corrections    
images_int                      = images; %intitialzes the intermediat images array.    
std_est                         = zeros(1,15);
[display_nb, ~] = find(cell2mat(get(S.channelProcessSelect, 'value'))==1);
    for J                       = display_nb'                                                                                                                  % Loops for the number of different channels in the image         
        channel_name = get(S.channelProcessText, 'string');
        switch char(channel_name{J})                                                                                                                                                   
                case 'Height'
                    j = 1;
                case 'Height Sensor'
                    j = 2;
                case 'Deflection'
                    j = 3;
                case 'Deflection Error'
                    j = 3;
                case 'Phase'
                    j = 4;
                case 'Amplitude'
                    j = 5;
                case 'Amplitude Error'
                    j = 6;
                case 'Potential'
                    j = 7;
                case 'Peak Force Error'
                    j = 8;
                case 'DMTModulus'
                    j = 9;
                case 'LogDMTModulus'
                    j = 10;
                case 'Adhesion'
                    j = 11;
                case 'Deformation'
                    j = 12;
                case 'Dissipation'
                    j = 13;
                case 'Input1'
                    j = 14;
                case 'Input2'
                    j = 15;
        end

        
        min_peak_distance       = min_peak_distance_ref(j);
        update_scrolltext([get(S.hText,'UserData');['Channel: ', channel_info(J).Name]],S.hText,S.hSlider);
        pause(0.0001);

        
        if S.processAll  ==  0  && j == 1                                      % process only one image AND first channel
            raw_images          = zeros(size(images,1), size(images,2), 15);    % Initialization 
            med_corr_1_images   = zeros(size(images,1), size(images,2), 15);    % Initialization
            ini_tilt_images     = zeros(size(images,1), size(images,2), 15);    % Initialization 
            poly_flat_1_images  = zeros(size(images,1), size(images,2), 15);    % Initialization 
            med_corr_2_images   = zeros(size(images,1), size(images,2), 15);    % Initialization 
            poly_flat_2_images  = zeros(size(images,1), size(images,2), 15);    % Initialization 
            final_images        = zeros(size(images,1), size(images,2), 15);    % Initialization 
        elseif S.processAll  ==  1  && j == 1
            raw_images          = zeros(size(images,1), size(images,2), 15);    % Initialization 
            med_corr_1_images   = zeros(size(images,1), size(images,2), 15);    % Initialization
            ini_tilt_images     = zeros(size(images,1), size(images,2), 15);    % Initialization 
            poly_flat_1_images  = zeros(size(images,1), size(images,2), 15);    % Initialization 
            med_corr_2_images   = zeros(size(images,1), size(images,2), 15);    % Initialization 
            poly_flat_2_images  = zeros(size(images,1), size(images,2), 15);    % Initialization 
            final_images        = zeros(size(images,1), size(images,2), 15);    % Initialization
        elseif size(images,1) ~= size(raw_images,1) || size(images,2) ~= size(raw_images,2)
            raw_images          = zeros(size(images,1), size(images,2), 15);    % Initialization 
            med_corr_1_images   = zeros(size(images,1), size(images,2), 15);    % Initialization
            ini_tilt_images     = zeros(size(images,1), size(images,2), 15);    % Initialization 
            poly_flat_1_images  = zeros(size(images,1), size(images,2), 15);    % Initialization 
            med_corr_2_images   = zeros(size(images,1), size(images,2), 15);    % Initialization 
            poly_flat_2_images  = zeros(size(images,1), size(images,2), 15);    % Initialization 
            final_images        = zeros(size(images,1), size(images,2), 15);    % Initialization
        end
 
        
            images(:,:,J)                           = images(:,:,J)-median(reshape(images(:,:,J),size(images(:,:,J),1)*size(images(:,:,J),2),1));
            raw_images(:,:,J)                       = images(:,:,J); % Saves the raw image 
        % Fit Image to Gaussians
        [gaussian_fit, gaussian_gof,n_peaks,pos,height]   = fit_multi_gauss(images(:,:,J),index,j,S,min_spacing_stdev_user,max_spacing_stdev_user,amplitude_fract,smoothing_level);
        %disp(gaussian_fit)
        hist_gof                                    = gaussian_gof.sse;
        if hist_gof >= 0.7
            total_area = 0;
            hist_std_ini = 0;
            for ii= 1:n_peaks
            total_area = total_area + eval(['gaussian_fit.a',num2str(ii)]);
            end
            
            for ii= 1:n_peaks
            hist_std_ini = hist_std_ini+1/2/sqrt(2)*eval(['gaussian_fit.c',num2str(ii),'*gaussian_fit.a',num2str(ii),'/total_area']);
            end
        else
            hist_std_ini                                = std(reshape(images(:,:,J),size(images(:,:,J),1)*size(images(:,:,J),2),1));
        end
        %disp(hist_std_ini)
        %dlmwrite([ImageDir,get(S.baseDirectoryText,'string'),filesep,'Figure PNGS',filesep,channel_info(J).Name,filesep,'text',filesep,'A ',tok,remain(2:4),'_raw.txt'],imresize(images(:,:,J),[max(size(images(:,:,J))),max(size(images(:,:,J)))]),'delimiter', '\t','precision', 5);
        max_peak_ampl               = 0;                                                                                                    % Variable to keep track of the maximum amplitude of the histogram for nice plotting
        % Plots the inital image and histogram
        if plot_intermediate_steps == 1
            if index<= 2
                summary_fig                         = figure('Name','Summary', 'OuterPosition', [1 1 1800 800]);
            else
                close(summary_fig)
                summary_fig                         = figure('Name','Summary', 'OuterPosition', [1 1 1800 800]);
            end
            subplot(2, 7, 1); 
            plot_nice_image;                                                                                                                       % Plots the current image
            title('Initial image')
            subplot(2, 7, 8); 
            hist(reshape(images(:,:,J),size(images,1)*size(images,2),1),histogram_bins)
            title ('Initial histogram')
        end
       
        if plot_tilt_check == 1
            figure(5);
            subplot(2, 5, 1); 
            imshow(images(:,:,J),[min(min(images(:,:,J))),max(max(images(:,:,J)))]);                                                                                                                       % Plots the current image
            title('Initial image')
            subplot(2, 5, 6); 

                plot(pos,height,'-k');
                hold on;
                plot(pos,gaussian_fit(pos),'--b');
                axis auto;
                axis square;
                set(gca,'Xlim',[min(min(images(:,:,J))),max(max(images(:,:,J)))]);
                xlabel(num2str(hist_std_ini));
                ylabel(num2str(hist_gof));
                hold off;
            title ('Initial histogram')
        end
        

%% Does an initial Median correction to fix basic line skips.  Don't use on grids or other similar structures
        saved_image_no_med_corr                                 = images(:,:,J);    % Saves the image before the median correction in order to use it later (to compare global tilt with or without median corr)
        if Med_corr(j) == 1                                                                                                                                                       % Allows user to turn median correction on or off

            update_scrolltext([get(S.hText,'UserData');'     --- First median correction ----'],S.hText,S.hSlider);
            pause(0.0001);
            [images(:,:,J),scar_line, hist_std, improv_param]   = medianCorrection(images(:,:,J), Inf, histogram_bins,smoothing_level);  
           
            images(:,:,J)                                       = images(:,:,J)-median(reshape(images(:,:,J),size(images(:,:,J),1)*size(images(:,:,J),2),1));
            med_corr_1_images(:,:,J)                            = images(:,:,J); % Saves the raw image 


%dlmwrite([ImageDir,get(S.baseDirectoryText,'string'),filesep,'Figure PNGS',filesep,channel_info(J).Name,filesep,'text',filesep,'C ',tok,remain(2:4),' 1st med.txt'],imresize(images(:,:,J),[max(size(images(:,:,J))),max(size(images(:,:,J)))]),'delimiter', '\t','precision', 5);

        
            if plot_intermediate_steps == 1
                figure(summary_fig)
                subplot(2, 7, 2);
                plot_nice_image;
                title('After 1st median correction')
                subplot(2, 7, 9);
                hist(reshape(images(:,:,J),size(images,1)*size(images,2),1),histogram_bins)
                title('Histogram')
                if (improv_param == 1)
                       xlabel('This step improved the image');
                else
                       xlabel('This step did NOT improve the image');
                end
                
            
            end
        else
            scar_line                               = zeros(1,size(images,1));
            [height_ini, position_ini]               = hist(reshape(images(:,:,J),size(images,1)*size(images,2),1),histogram_bins);                                                                 % Calculates the inital histogram
            height_ini                              = 100*height_ini/sum(height_ini); 
            hist_std                                = std(position_ini);      
        
        end
       
    
        final_flattening_image                          = images(:,:,J);                                                                                                % Saves the image to do a direct final flattening with the final mask
         
%% Does an initial tilt correction to fix some of the initial sample tilt.  Needed before doing any histogrammed flattening                                                     % Determines the number of coeffecients for the user selected polynomial order
        saved_image                                 = images(:,:,J);
        
        % FIRST order for polynomial fitting (1st order for both horizontal
        % and vertical fit, WITH median correction
        if Med_corr(j) == 1 
            initial_poly_order_horizontal               = min([1,poly_order_horiz(j)]);
            initial_poly_order_vertical                 = min([1,poly_order_vert(j)]);
            %coef_length                                 = nchoosek(max([initial_poly_order_horizontal,initial_poly_order_vertical])+2,2);                                                      % Determines the number of coeffecients for the user selected polynomial order
            [xInput, yInput, zOutput]                   = prepareSurfaceData(1:size(images(:,:,J),1),1:size(images(:,:,J),2) , images(:,:,J));                                              % Preps vectors for surface fitting
            poly_type                                   = fittype( ['poly',num2str(initial_poly_order_vertical),num2str(initial_poly_order_horizontal)] );                                     % Sets the fit type to be an X-Y polynomial of user choice       
            poly_opts                                   = fitoptions( poly_type );                                                                                                          % Sets the fit  construction
            coef_length                                 = numcoeffs(poly_type);
            if index <= 2
                poly_opts.Lower                         = -Inf*ones(coef_length,1);                                                                                                         % Sets the lower bounds
                poly_opts.Upper                         =  Inf*ones(coef_length,1);                                                                                                         % Sets the upper bounds
            else
                poly_opt.Lower                          = coeffvalues(Init_poly_coef_1st_med{index-1,j})-0.5*abs(coeffvalues(Init_poly_coef_1st_med{index-1,j}));
                poly_opt.Upper                          = coeffvalues(Init_poly_coef_1st_med{index-1,j})+0.5*abs(coeffvalues(Init_poly_coef_1st_med{index-1,j}));
            end
            [poly_result]                               = fit( [xInput, yInput], zOutput, poly_type, poly_opts );                                                                           % Fits the polynomial to the actual data
            images(:,:,J)                               = images(:,:,J) - reshape(poly_result([xInput,yInput]),size(images(:,:,J),1),size(images(:,:,J),2));
            images(:,:,J)                               = images(:,:,J) - median(reshape(images(:,:,J),size(images,1)*size(images,2),1));
            Init_poly_coef_1st_med{index,j}             = poly_result;
            saved_image_1st_order_fit_med_cor           = images(:,:,J);       
            images(:,:,J)                               = saved_image_no_med_corr;
        else
            coef_length                                 = nchoosek(max([1,1])+2,2);                                                      % Determines the number of coeffecients for the user selected polynomial order
            scar_line                                   = zeros(1,size(images,1));
            [height_ini, position_ini]                   = hist(reshape(images(:,:,J),size(images,1)*size(images,2),1),histogram_bins);                                                                 % Calculates the inital histogram
            height_ini                                  = 100*height_ini/sum(height_ini); 
            hist_std                                    = std(position_ini);
            Init_poly_coef_1st_med{index,j}             = zeros(1,coef_length);
            saved_image_1st_order_fit_med_cor           = images(:,:,J);       
        end
        
        % FIRST order for polynomial fitting (1st order for both horizontal
        % and vertical fit, WITHOUT median correction
        initial_poly_order_horizontal               = min([1,poly_order_horiz(j)]);
        initial_poly_order_vertical                 = min([1,poly_order_vert(j)]);
        %coef_length                                 = nchoosek(max([initial_poly_order_horizontal,initial_poly_order_vertical])+2,2);                                                      % Determines the number of coeffecients for the user selected polynomial order
        [xInput, yInput, zOutput]                   = prepareSurfaceData(1:size(images(:,:,J),1),1:size(images(:,:,J),2) , images(:,:,J));                                              % Preps vectors for surface fitting
        poly_type                                   = fittype( ['poly',num2str(initial_poly_order_vertical),num2str(initial_poly_order_horizontal)] );                                     % Sets the fit type to be an X-Y polynomial of user choice       
        poly_opts                                   = fitoptions( poly_type );                                                                                                          % Sets the fit  construction
        coef_length                                 = numcoeffs(poly_type);
        if index<= 2
            poly_opts.Lower                         = -Inf*ones(coef_length,1);                                                                                                         % Sets the lower bounds
            poly_opts.Upper                         =  Inf*ones(coef_length,1);                                                                                                         % Sets the upper bounds
        else
            poly_opt.Lower                          = coeffvalues(Init_poly_coef_1st_nomed{index-1,j})-0.5*abs(coeffvalues(Init_poly_coef_1st_nomed{index-1,j}));
            poly_opt.Upper                          = coeffvalues(Init_poly_coef_1st_nomed{index-1,j})+0.5*abs(coeffvalues(Init_poly_coef_1st_nomed{index-1,j}));
        end
        [poly_result]                               = fit( [xInput, yInput], zOutput, poly_type, poly_opts );                                                                           % Fits the polynomial to the actual data
        images(:,:,J)                               = images(:,:,J) - reshape(poly_result([xInput,yInput]),size(images(:,:,J),1),size(images(:,:,J),2));
        images(:,:,J)                               = images(:,:,J) - median(reshape(images(:,:,J),size(images,1)*size(images,2),1));
        Init_poly_coef_1st_nomed{index,j}           = poly_result;
        saved_image_1st_order_fit                   = images(:,:,J);

        % SECOND order for polynomial fitting (2nd order for both horizontal
        % and vertical fit, WITH median correction
        if poly_order_horiz(j) >=2 && poly_order_vert(j) >=2
            if Med_corr(j) == 1 
                images(:,:,J)                               = saved_image;
                initial_poly_order_horizontal               = min([2,poly_order_horiz(j)]);
                initial_poly_order_vertical                 = min([2,poly_order_vert(j)]);
                %coef_length                                 = nchoosek(max([initial_poly_order_horizontal,initial_poly_order_vertical])+2,2);                                                      % Determines the number of coeffecients for the user selected polynomial order
                [xInput, yInput, zOutput]                   = prepareSurfaceData(1:size(images(:,:,J),1),1:size(images(:,:,J),2) , images(:,:,J));                                              % Preps vectors for surface fitting
                poly_type                                   = fittype( ['poly',num2str(initial_poly_order_vertical),num2str(initial_poly_order_horizontal)] );                                     % Sets the fit type to be an X-Y polynomial of user choice       
                poly_opts                                   = fitoptions( poly_type );                                                                                                          % Sets the fit  construction
                coef_length                                 = numcoeffs(poly_type);
                if index<= 2
                    poly_opts.Lower                         = -Inf*ones(coef_length,1);                                                                                                         % Sets the lower bounds
                    poly_opts.Upper                         =  Inf*ones(coef_length,1);                                                                                                         % Sets the upper bounds
                else
                    poly_opt.Lower                          = coeffvalues(Init_poly_coef_2nd_med{index-1,j})-0.5*abs(coeffvalues(Init_poly_coef_2nd_med{index-1,j}));
                    poly_opt.Upper                          = coeffvalues(Init_poly_coef_2nd_med{index-1,j})+0.5*abs(coeffvalues(Init_poly_coef_2nd_med{index-1,j}));
                end
                [poly_result]                               = fit( [xInput, yInput], zOutput, poly_type, poly_opts );                                                                           % Fits the polynomial to the actual data
                images(:,:,J)                               = images(:,:,J) - reshape(poly_result([xInput,yInput]),size(images(:,:,J),1),size(images(:,:,J),2));
                images(:,:,J)                               = images(:,:,J) - median(reshape(images(:,:,J),size(images,1)*size(images,2),1));
                Init_poly_coef_2nd_med{index,j}             = poly_result;
                saved_image_2nd_order_fit_med_cor           = images(:,:,J);
                images(:,:,J)                               = saved_image_no_med_corr;
            else
                coef_length                                 = nchoosek(max([2,2])+2,2);                                                      % Determines the number of coeffecients for the user selected polynomial order
                Init_poly_coef_2nd_med{index,j}             = zeros(1,coef_length);
                saved_image_2nd_order_fit_med_cor           = images(:,:,J);
            end
            
            % SECOND order for polynomial fitting (2nd order for both horizontal
            % and vertical fit, WITHOUT median correction
            initial_poly_order_horizontal               = min([2,poly_order_horiz(j)]);
            initial_poly_order_vertical                 = min([2,poly_order_vert(j)]);
            %coef_length                                 = nchoosek(max([initial_poly_order_horizontal,initial_poly_order_vertical])+2,2);                                                      % Determines the number of coeffecients for the user selected polynomial order
            [xInput, yInput, zOutput]                   = prepareSurfaceData(1:size(images(:,:,J),1),1:size(images(:,:,J),2) , images(:,:,J));                                              % Preps vectors for surface fitting
            poly_type                                   = fittype( ['poly',num2str(initial_poly_order_vertical),num2str(initial_poly_order_horizontal)] );                                     % Sets the fit type to be an X-Y polynomial of user choice       
            poly_opts                                   = fitoptions( poly_type );                                                                                                          % Sets the fit  construction
            coef_length                                 = numcoeffs(poly_type);
            if index<= 2
                poly_opts.Lower                         = -Inf*ones(coef_length,1);                                                                                                         % Sets the lower bounds
                poly_opts.Upper                         =  Inf*ones(coef_length,1);                                                                                                         % Sets the upper bounds
            else
                poly_opt.Lower                          = coeffvalues(Init_poly_coef_2nd_nomed{index-1,j})-0.5*abs(coeffvalues(Init_poly_coef_2nd_nomed{index-1,j}));
                poly_opt.Upper                          = coeffvalues(Init_poly_coef_2nd_nomed{index-1,j})+0.5*abs(coeffvalues(Init_poly_coef_2nd_nomed{index-1,j}));
            end
            [poly_result]                               = fit( [xInput, yInput], zOutput, poly_type, poly_opts );                                                                           % Fits the polynomial to the actual data
            images(:,:,J)                               = images(:,:,J) - reshape(poly_result([xInput,yInput]),size(images(:,:,J),1),size(images(:,:,J),2));
            images(:,:,J)                               = images(:,:,J) - median(reshape(images(:,:,J),size(images,1)*size(images,2),1));
            Init_poly_coef_2nd_nomed{index,j}           = poly_result;
            saved_image_2nd_order_fit                   = images(:,:,J); 
        else
            coef_length                                 = nchoosek(max([2,2])+2,2);                                                      % Determines the number of coeffecients for the user selected polynomial order
            Init_poly_coef_2nd_med{index,j}             = zeros(1,coef_length);
            saved_image_2nd_order_fit_med_cor           = images(:,:,J);
            Init_poly_coef_2nd_nomed{index,j}           = zeros(1,coef_length);
            saved_image_2nd_order_fit                   = images(:,:,J);
        end
%         saved_image_2nd_order_fit          = saved_image_1st_order_fit;
%         saved_image_2nd_order_fit_med_cor  = saved_image_1st_order_fit_med_cor;


         % In order to really find the best tilt correction, not take the
         % std of the whole image but the part of the image between cdf =
         % 3% and 97%:
         tilt_corr_names = ['saved_image_1st_order_fit        '; ...
                            'saved_image_2nd_order_fit        '; ...
                            'saved_image_1st_order_fit_med_cor'; ...
                            'saved_image_2nd_order_fit_med_cor'];

%          figure('Name','Tilt Options')
        tilt_hist_std  = zeros(1,4);
        tilt_hist_gof  = zeros(1,4);
        for ii = 1:4   % for the four different tilt corrections
            eval(['images(:,:,J) = ', num2str(tilt_corr_names(ii,:)), ';']);
            [h_lim, x_lim]                                       = ecdf(reshape(images(:,:,J),size(images,1)*size(images,2),1));
            min_hist                                            = x_lim(find(h_lim >= 0.005,1));
            max_hist                                            = x_lim(find(h_lim >= 0.995,1));
            image_inside_range                                  = images(:,:,J);
            image_inside_range((images(:,:,J) < min_hist ))     = NaN;                                                                                                              
            image_inside_range((images(:,:,J) > max_hist ))     = NaN;
            image_inside_range_list                             = reshape(image_inside_range(:,:),size(image_inside_range,1)*size(image_inside_range,2),1);                         % Calculates the histogram of the corrected height data (First image only)
            tilt_hist_std(ii)                                   = std(image_inside_range_list(~isnan(image_inside_range_list)));

            [gaussian_fit, gaussian_gof,~,pos,height]           = fit_multi_gauss(image_inside_range,index,j,S,min_spacing_stdev_user,max_spacing_stdev_user,amplitude_fract,smoothing_level);
            tilt_hist_gof(ii)                                   = gaussian_gof.sse;
        
            if plot_tilt_check == 1
                figure(5);
                subplot(2, 5, 6+ii); 
                    plot(pos,height,'-k');
                    hold on;
                    plot(pos,gaussian_fit(pos),'--b');
                    axis auto;
                    axis square;
                    set(gca,'Xlim',[min_hist,max_hist]);
                    title(tilt_corr_names(ii,:));
                    xlabel(['Standard Deviation: ',num2str(tilt_hist_std(ii))])
                    ylabel(['GOF Parameter: ',num2str(tilt_hist_gof(ii))]);
                    hold off;
                 subplot(2, 5, 1+ii); 
                    imshow(images(:,:,J),[min_hist,max_hist]);                                                                                                                       % Plots the current image
                    title(tilt_corr_names(ii,:));
                    
            end
        end
        if plot_intermediate_steps == 1
            figure(summary_fig)
        end

        
            update_scrolltext([get(S.hText,'UserData');'     --- Tilt correction ----'],S.hText,S.hSlider);
            pause(0.0001);
%          
%              disp(tilt_hist_std)
%              disp(tilt_hist_gof)
%              disp(tilt_hist_std./tilt_hist_gof)
% 
%              disp(hist_std) 
%              disp(hist_gof)
%        if (min(tilt_hist_std) > hist_std) || (min(tilt_hist_gof > 0) < hist_gof)            % if none of the different tilt corrections improved the image

        if min(tilt_hist_std) > hist_std            % if none of the different tilt corrections improved the image
%dlmwrite([ImageDir,get(S.baseDirectoryText,'string'),filesep,'Figure PNGS',filesep,channel_info(J).Name,filesep,'text',filesep,'D ',tok,remain(2:4),' tilt fail.txt'],imresize(images(:,:,J),[max(size(images(:,:,J))),max(size(images(:,:,J)))]),'delimiter', '\t','precision', 5);
            std_est(j)                          = hist_std;  
            images(:,:,J)                       = saved_image;            % Cancels the tilt correction
            Init_poly_coef{index,j}             = zeros(size(Init_poly_coef_1st_nomed{index,j}));
            update_scrolltext([get(S.hText,'UserData');'     Neither the 1st order nor the 2nd order inital tilt correction did improve the image'],S.hText,S.hSlider);
            pause(0.0001);
            if plot_intermediate_steps == 1
                subplot(2, 7, 10);
                xlabel('This step did NOT improve the image')
            end 
        else
           %[std_est(j),  best_tilt_corr]       = min(tilt_hist_std./tilt_hist_gof >= 0);
           %[std_est(j),  best_tilt_corr]        = min(tilt_hist_gof);
           [std_est(j),  best_tilt_corr]       = min(tilt_hist_std);
           corr_coeff_1st_pass                  = {Init_poly_coef_1st_med{index,j},Init_poly_coef_1st_nomed{index,j},Init_poly_coef_2nd_med{index,j},Init_poly_coef_2nd_nomed{index,j}};
           Init_poly_coef{index,j}              = corr_coeff_1st_pass{best_tilt_corr};
           images_size                          = size(saved_image_1st_order_fit, 1);
           all_tilt_corr_im                     = [saved_image_1st_order_fit; saved_image_2nd_order_fit; saved_image_1st_order_fit_med_cor; saved_image_2nd_order_fit_med_cor];
           images(:,:,J)                        = all_tilt_corr_im(images_size*(best_tilt_corr-1)+1:images_size*best_tilt_corr, :);      % Puts in images(:,:,J) the best image of the median/tilt corrections step
           titles = ['Tilt 1st order without med cor'; 'Tilt 2nd order without med cor'; 'Tilt 1st order  with  med  cor'; 'Tilt 2nd order  with  med  cor'];
           update_scrolltext([get(S.hText,'UserData');['          Best tilt correction: ', titles(best_tilt_corr, :)]],S.hText,S.hSlider);
           pause(0.0001);
           if plot_intermediate_steps == 1
               subplot(2, 7, 10); 
               xlabel(['best corr: ', titles(best_tilt_corr, :)])
           end
            %dlmwrite([ImageDir,get(S.baseDirectoryText,'string'),filesep,'Figure PNGS',filesep, channel_info(J).Name,filesep,'text',filesep,'D ',tok,remain(2:4), titles(best_tilt_corr, :), '.txt'],imresize(images(:,:,J),[max(size(images(:,:,J))),max(size(images(:,:,J)))]),'delimiter', '\t','precision', 5);
           images_int(:,:,j)                    = all_tilt_corr_im(images_size*(best_tilt_corr-1)+1:images_size*best_tilt_corr, :);      % Puts in images(:,:,J) the best image of the median/tilt corrections step
         end
         
        if S.processAll  ==  0          % process only one image 
            images(:,:,J)                       = images(:,:,J)-median(reshape(images(:,:,J),size(images(:,:,J),1)*size(images(:,:,J),2),1));
            ini_tilt_images(:,:,J)              = images(:,:,J); % Saves the raw image 
        else
            images(:,:,J)                       = images(:,:,J)-median(reshape(images(:,:,J),size(images(:,:,J),1)*size(images(:,:,J),2),1));
        end

         
        if plot_intermediate_steps == 1
            figure(summary_fig)
            subplot(2, 7, 3);
            plot_nice_image;
            title('After inital tilt correction')
            subplot(2, 7, 10);
            hold on;
        end
        
        % This subtracts the median of the image from the image and
        % calculates the range of the image values so that all histograms have the same range
        % images(:,:,J)                           = images(:,:,J)-median(reshape(images(:,:,J),size(images(:,:,J),1)*size(images(:,:,J),2),1));
        
%% Generates initial fitting bound estimates
        [h_lim, x_lim]                               = ecdf(reshape(images(:,:,J),size(images,1)*size(images,2),1));
        min_hist                                    = floor(x_lim(find(h_lim >= 0.02,1)));
        max_hist                                    =  ceil(x_lim(find(h_lim >= 0.98,1)));
        
        image_inside_range                          = images(:,:,J);
        image_inside_range((images(:,:,J) < min_hist)) = NaN;                                                                                                              
        image_inside_range((images(:,:,J) > max_hist)) = NaN; 
        
        [height_est, position_est]                   = hist(reshape(image_inside_range(:,:),size(image_inside_range,1)*size(image_inside_range,2),1),histogram_bins);                                                                 % Calculates the histogram of the corrected height data (First image only)
        height_est                                  = 100*height_est/sum(height_est);
        height_est                                  = smooth(height_est,smoothing_level,'loess');
        min_peak_height                             = min([min_peak_height_ref(j),0.9*max(height_est)]);
        min_peak_distance_temp                      = min([ceil(min_peak_distance/mean(diff(position_est))),length(height_est)-1]);
        [peak_height_est, peak_index_est]            = findpeaks(height_est,'MinpeakDistance', min_peak_distance_temp , 'MinpeakHeight', min_peak_height, 'Threshold', peak_threshold, 'Sortstr','descend');                                                                    % Finds up to four peaks in the corrected image to identify different terraces
     
        if sort_peaks(j) == 1
            peak_index_est                          = sort(peak_index_est(1:min([peaks_fit(j),3, length(peak_height_est)])),'ascend');
        else
            peak_index_est                          = peak_index_est(1:min([peaks_fit(j),3, length(peak_height_est)]));
        end


        if Calc_flatten_lim(j) == 1 
            max_spacing_stdev(index,j)  = 2.00*sqrt(2)*std_est(j);
            min_spacing_stdev(index,j)  = 0.05*sqrt(2)*std_est(j);
        else
            min_spacing_stdev(index,j)  = sqrt(2)*min_spacing_stdev_user(j);
            max_spacing_stdev(index,j)  = sqrt(2)*max_spacing_stdev_user(j);

        end

         if plot_intermediate_steps == 1
            figure(summary_fig)
            subplot(2, 7, 10);
            title('Histogram')
            image_inside_range                                  = images(:,:,J);
            image_inside_range((images(:,:,J) < min_hist))      = NaN;          
            image_inside_range((images(:,:,J) > max_hist))      = NaN; 
            hist(reshape(image_inside_range(:,:),size(image_inside_range,1)*size(image_inside_range,2),1),histogram_bins);
         end
        
        if plot_intermediate_image == 1
            save_intermediate_image;
        end
        
%        min_peak_distance_temp                      = min([ceil(min_peak_distance/mean(diff(position_est))),length(height_est)-1]);
%        [peak_height_est peak_index_est]            = findpeaks(height_est,'MinpeakDistance', min_peak_distance_temp , 'MinpeakHeight', min_peak_height, 'Threshold', peak_threshold, 'Sortstr','descend');                                                                    % Finds up to four peaks in the corrected image to identify different terraces
%        peak_index_est                              = peak_index_est(1:min([peaks_fit(j),3, length(peak_height_est)]));
         
        ref_peak_pos = position_est(peak_index_est);        % Peaks reference positions to find corresponding peaks
         if plot_intermediate_steps == 1
            figure(summary_fig)
            subplot(2, 7, 10)
            plot(position_est(peak_index_est), height_est(peak_index_est), 'k^', 'MarkerEdgeColor','k', 'MarkerFaceColor', 'g')
            hold off;
         end
        
%% This section histograms the image, identifies up to 3 distinct levels in the historam, fits them to Gaussians, and uses this to determin an approriate threshold range to use for a masked polynomial approach.  This leads to truly flat planes that are not biased by steps and terraces in the image data
        saved_image                                     = images(:,:,J);
        [h_lim, x_lim]                                   = ecdf(reshape(images(:,:,J),size(images,1)*size(images,2),1));
        min_hist                                        = floor(x_lim(find(h_lim >= 0.03,1)));
        max_hist                                        =  ceil(x_lim(find(h_lim >= 0.97,1)));
        
        image_inside_range                              = images(:,:,J);
        image_inside_range((images(:,:,J) < min_hist )) = NaN;                                                                                                              
        image_inside_range((images(:,:,J) > max_hist )) = NaN;
        
        [gaussian_fit, ~,n_peaks,~,~]                   = fit_multi_gauss(image_inside_range,index,j,S,min_spacing_stdev_user,max_spacing_stdev_user,amplitude_fract,smoothing_level);

       
         peaks_nb                                       = n_peaks;
         for i                                          = 1:n_peaks       % Detects peaks smaller than min_peak_height; peaks found by findpeaks are bigger than this value, but if gaussian fit not good, peaks smaller can 'apppear'
             eval(['peak_ampl = gaussian_fit.a', num2str(i), ';']);
             if peak_ampl                               < min_peak_height
                 peaks_nb                               = peaks_nb - 1;
             end
         end

        % Combines all the amplitudes, the positions and the standard
        % deviations into one vector and sets the lower and upper threshold
        % for all peaks
         gaussian_fit_ampl                              = [];
         gaussian_fit_pos                               = [];
         gaussian_fit_std                               = [];
         for i = 1:peaks_nb
            eval(['gaussian_fit_ampl(', num2str(i), ')= gaussian_fit.a', num2str(i), ';']);
            eval(['gaussian_fit_pos(', num2str(i), ')= gaussian_fit.b', num2str(i), ';']);
            eval(['gaussian_fit_std(', num2str(i), ')= gaussian_fit.c', num2str(i), ';']);
         end
       
         % For the overlap checking, sort the peaks in ascending order (in
         % term of position)
         if peaks_nb == 1
             peak_gaussian_pos                          = gaussian_fit_pos;
             peak_gaussian_std                          = gaussian_fit_std;
             peak_gaussian_ampl                         = gaussian_fit_ampl;
         else
             [peak_gaussian_pos, ind]                   = sort(gaussian_fit_pos, 'ascend');
             peak_gaussian_std                          = zeros(1,peaks_nb);
             peak_gaussian_ampl                         = zeros(1,peaks_nb);
             for i                                      = 1:peaks_nb
                peak_gaussian_std(i)                    = gaussian_fit_std(ind(i));
                peak_gaussian_ampl(i)                   = gaussian_fit_ampl(ind(i));
             end
         end
         
           % For each peak, calculates the lower and upper threshold
           for i = 1:peaks_nb     
            eval(['thresh_low_', num2str(i), ' = peak_gaussian_pos(', num2str(i), ') - thresh_range*peak_gaussian_std(', num2str(i), ');']);
            eval(['thresh_high_', num2str(i), ' = peak_gaussian_pos(', num2str(i), ') + thresh_range*peak_gaussian_std(', num2str(i), ');']);
           end
         
         % For each pair of peaks, look if they overlap and what is their
         % intersection point
         if peaks_nb  == 1                                                                                                                                              % Only one peak, so no problem of overlap
             % do nothing
         else
             for i = 1:peaks_nb-1
                 fct = @(x)(peak_gaussian_ampl(i)*exp(-(x-peak_gaussian_pos(i)).^2./(2*(peak_gaussian_std(i))^2))- peak_gaussian_ampl(i+1)*exp(-(x-peak_gaussian_pos(i+1)).^2./(2*(peak_gaussian_std(i+1))^2)));
                 eval(['thresh_start_x = (thresh_low_', num2str(i), '+ thresh_high_', num2str(i+1), ')/2;']);
                [intersect_x, fval, exit_flag] = fzero(fct, thresh_start_x);                                                                                                         % Finds intersection of the two peaks
%                 plot(intersect_x, peak_gaussian_ampl(i)*exp(-(intersect_x-peak_gaussian_pos(i)).^2./(2*(peak_gaussian_std(i))^2)), 'rx', 'MarkerSize', 12);
%                 hold off;
                if intersect_x > peak_gaussian_pos(i)+ 5*peak_gaussian_std(i) || intersect_x < peak_gaussian_pos(i) - 5*peak_gaussian_std(i)        % Wrong zero was found; it can happen when the intersection point is where the gaussian curves tend to zero
                exit_flag = 0;                                                                                                                      % Sets the exit_flag to a value different of 1 so it doesn't do anything
                end
                if exit_flag == 1                                                                                                                                                         % An intersection point between the two peaks was found
                    if i == 1
                         if thresh_high_1 > intersect_x
                            thresh_high_1 = intersect_x;                                                                                                            % Sets the upper threshold of the first peak to the intersection position
                         end
                         if thresh_low_2  < intersect_x
                            thresh_low_2  = intersect_x;                                                                                                              % Sets the lower threshold of the second peak to the intersection position
                         end
                    end
                    if i == 2       % (i can be equal to 1 or 2)
                         if thresh_high_2 > intersect_x
                            thresh_high_2 = intersect_x;                                                                                                            % Sets the upper threshold of the first peak to the intersection position
                         end
                         if thresh_low_3  < intersect_x
                            thresh_low_3  = intersect_x;                                                                                                              % Sets the lower threshold of the second peak to the intersection position
                         end  
                    end
                end
             end
         end
         
         % Put the peaks in their originial order (largest amplitude first)
          [peak_gaussian_ampl, ind] = sort(peak_gaussian_ampl, 'ascend');
           for i = 1:peaks_nb 
                eval(['thresh_low(', num2str(i), ') = thresh_low_', num2str(ind(i)), ';']);
                eval(['thresh_high(', num2str(i), ') = thresh_high_', num2str(ind(i)), ';']);
           end
             
         % Set the lower and upper threshold of the peak to be flattened
         if peaks_nb >= peak_to_flatten(j)
             eval(['thresh_low = thresh_low_', num2str(peak_to_flatten(j)), ';']);
             eval(['thresh_high = thresh_high_', num2str(peak_to_flatten(j)), ';']);
         else
             thresh_low = thresh_low_1;
             thresh_high = thresh_high_1;
         end    
         
        image_test                                  = images(:,:,J);                                                                                                                    % Duplicates the images as a placeholder for the thresholding
        image_test((images(:,:,J) < thresh_low))    = NaN;                                                                                                                              % Thresholds out all of the data below
        image_test((images(:,:,J) > thresh_high))   = NaN;                                                                                                                              % Thresholds out all of the data above

        
% % Plot Corrected Data within the mask and Fit
% figure ('Name','First Poly Mask')
% subplot(2,1,1)
% imshow(image_test,[thresh_low thresh_high]);
% colormap(mycmap_sky); 
% colorbar;
% subplot(2,1,2)
% plot(position_1,height_1);
% hold on;
% plot(gaussian_fit,'r');
% hold off;
% axis square;
% axis tight;
%  
        First_Thresh_File = [ImageDir,get(S.baseDirectoryText,'string'),filesep,'first_threshold.txt'];
        
    if  index == 1 && j == 1  
        fid = fopen(First_Thresh_File, 'a');
        fprintf(fid, [  'Image','\t',...
                        'Channel','\t',...
                        'Thresh Low','\t',...
                        'Thresh High','\n'],...
                        'char');
                    
        fprintf(fid, [  num2str(file_number,'%0.0f'),'\t',...
                        channel_info(J).Name,'\t',...
                        num2str(thresh_low,'%0.0f'),'\t',...
                        num2str(thresh_high,'%0.3f'),'\n'],...
                        'char');
        fclose(fid);
    else
        fid = fopen(First_Thresh_File, 'a');
        fprintf(fid, [  num2str(file_number,'%0.0f'),'\t',...
                        channel_info(J).Name,'\t',...
                        num2str(thresh_low,'%0.0f'),'\t',...
                        num2str(thresh_high,'%0.3f'),'\n'],...
                        'char');
        fclose(fid);
    end
        
        % Fit the thresholded surface to an n x m polynomial 
        % Loops for the number of images
        %coef_length                                 = nchoosek(max([poly_order_horiz(j),poly_order_vert(j)])+2,2);                                                                      % Determines the number of coeffecients for the user selected polynomial order
        [xInput_poly, yInput_poly, zOutput_poly]    = prepareSurfaceData(1:size(images(:,:,J),1),1:size(images(:,:,J),2) , image_test);                                                 % Preps vectors for surface fitting
        poly_type                                   = fittype( ['poly',num2str(poly_order_vert(j)),num2str(poly_order_horiz(j))] );                                                     % Sets the fit type to be an X-Y polynomial of user choice       
        poly_opts                                   = fitoptions( poly_type );                                                                                                          % Sets the fit  construction
        coef_length                                 = numcoeffs(poly_type);
        if index<= 2
            poly_opts.Lower                         = -Inf*ones(coef_length,1);                                                                                                         % Sets the lower bounds
            poly_opts.Upper                         =  Inf*ones(coef_length,1);                                                                                                         % Sets the upper bounds
        else
            poly_opt.Lower                          = coeffvalues(Second_poly_coef{index-1,j})-0.5*abs(coeffvalues(Second_poly_coef{index-1,j}));
            poly_opt.Upper                          = coeffvalues(Second_poly_coef{index-1,j})+0.5*abs(coeffvalues(Second_poly_coef{index-1,j}));
        end                                                                                                       % Sets the upper bounds
        
        poly_result                                 = fit( [xInput_poly, yInput_poly], zOutput_poly, poly_type, poly_opts );                                                            % Fits the polynomial to the actual data
        images(:,:,J)                               = images(:,:,J) - reshape(poly_result([xInput,yInput]),size(images(:,:,J),1),size(images(:,:,J),2));
        Second_poly_coef{index,j}                   = poly_result;
        images(:,:,J)                               = images(:,:,J)-median(reshape(images(:,:,J),size(images(:,:,J),1)*size(images(:,:,J),2),1));
        
            if S.processAll  ==  0          % process only one image 
                poly_flat_1_images(:,:,J) = images(:,:,J); % Saves the raw image 
            end

        if plot_intermediate_steps == 1
            figure(summary_fig)
            subplot(2, 7, 4);
            plot_nice_image;
            title('After 1st polynomial flattening')
            subplot(2, 7, 11);
            image_inside_range                                  = images(:,:,J);
            image_inside_range((images(:,:,J) < min_hist))      = NaN;                                                                                                              
            image_inside_range((images(:,:,J) > max_hist))      = NaN; 
            hist(reshape(image_inside_range(:,:),size(image_inside_range,1)*size(image_inside_range,2),1),histogram_bins);
            title('Histogram')
            xlabel('This step improved the image');
        end
        
        % Checks if the polynomial flattening brought some improvement or
        % not
        update_scrolltext([get(S.hText,'UserData');'     --- First Poly Flattening ----'],S.hText,S.hSlider);
        pause(0.0001);
        [improv_param_thresh1, peak_2_gaussian_std, peak_2_gaussian_ampl] = check_improvement(images(:,:,J), ...
                                                                    gaussian_fit_std, gaussian_fit_ampl,...
                                                                    min_spacing_stdev(index,j), max_spacing_stdev(index,j), ...
                                                                    amplitude_fract,  min_peak_distance, min_peak_height, peak_threshold, ...
                                                                    position_est, peak_height_est, peak_index_est, ...
                                                                    peak_pos_tolerance, histogram_bins, smoothing_level,...
                                                                    min_hist, max_hist ,ref_peak_pos, peaks_fit(j),j,S,index);
        if max(peak_gaussian_ampl)                                >  max_peak_ampl
            max_peak_ampl                                         = max(peak_gaussian_ampl);
        end
        if improv_param_thresh1 < 0                         % If true, the polynomial flattening didn't bring an improvement
            %dlmwrite([ImageDir,get(S.baseDirectoryText,'string'),filesep,'Figure PNGS',filesep,channel_info(J).Name,filesep,'text',filesep,'E ',tok,remain(2:4),' poly 1 fail.txt'],imresize(images(:,:,J),[max(size(images(:,:,J))),max(size(images(:,:,J)))]),'delimiter', '\t','precision', 5);
            images(:,:,J)                                           = saved_image;            % Cancels the polynomial flattening
            peak_2_gaussian_std                                     = gaussian_fit_std;
            peak_2_gaussian_ampl                                    = gaussian_fit_ampl;
            update_scrolltext([get(S.hText,'UserData');'          The first polymomial flattening did NOT improve the image'],S.hText,S.hSlider);
            pause(0.0001);
            if plot_intermediate_steps == 1
                xlabel('This step did NOT improve the image');
            end
        else
            max_spacing_stdev(index,j)                              = 1.25*peak_2_gaussian_std(min([peaks_fit(j),length(peaks_fit(j))]));
            min_spacing_stdev(index,j)                              = 0.25*peak_2_gaussian_std(min([peaks_fit(j),length(peaks_fit(j))]));
            update_scrolltext([get(S.hText,'UserData');'          The first polymomial flattening improved the image'],S.hText,S.hSlider);
            pause(0.0001);
            %dlmwrite([ImageDir,get(S.baseDirectoryText,'string'),filesep,'Figure PNGS',filesep,channel_info(J).Name,filesep,'text',filesep,'E ',tok,remain(2:4),' poly 1 win.txt'],imresize(images(:,:,J),[max(size(images(:,:,J))),max(size(images(:,:,J)))]),'delimiter', '\t','precision', 5);
        end
        if improv_param_thresh1 == 0                       
            if plot_intermediate_steps == 1
               xlabel('No change')
            end
        end
         
        offset_sub                                                  = median(reshape(images(:,:,J),size(images(:,:,J),1)*size(images(:,:,J),2),1));
        images(:,:,J)                                               = images(:,:,J) - offset_sub;
        thresh_low                                                  = thresh_low    - offset_sub;
        thresh_high                                                 = thresh_high   - offset_sub;      

    % Refine reference peaks:
        [h_lim, x_lim]                                               = ecdf(reshape(images(:,:,J),size(images,1)*size(images,2),1));
        mask_z_min                                                  = floor(x_lim(find(h_lim >= 0.02,1)));
        mask_z_max                                                  =  ceil(x_lim(find(h_lim >= 0.98,1)));
        image_inside_range                                          = images(:,:,J);
        image_inside_range((images(:,:,J) < mask_z_min ))           = NaN;                                                                                                              
        image_inside_range((images(:,:,J) > mask_z_max ))           = NaN; 
        [height, position]                                           = hist(reshape(image_inside_range(:,:),size(image_inside_range,1)*size(image_inside_range,2),1),histogram_bins);                         % Calculates the histogram of the corrected height data (First image only)
        height                                                      = 100*height/sum(height);
        height                                                      = smooth(height,smoothing_level,'loess');
        min_peak_height                                             = min([min_peak_height_ref(j),0.9*max(height)]);
        min_peak_distance_temp                                      = min([ceil(min_peak_distance/mean(diff(position))),length(height)-1]);
        [peak_height, peak_index]                                    = findpeaks(height,'MinpeakDistance',min_peak_distance_temp, 'MinpeakHeight', min_peak_height, 'Threshold', peak_threshold, 'Sortstr','descend');                                                                  % Finds up to four peaks in the corrected image to identify different terraces
        peak_index                                                  = find_closest(ref_peak_pos, peak_index(1:min(7, length(peak_index))), position); % peak_index_1(1:...): to keep only the 5 higher peaks
        ref_peak_pos                                                = position(peak_index);  
        
       
%% After the first round of thresholded plane correction this does another median correction, respecting the above thresholds to correct scaring
        
        if Med_corr_2(j) == 1
            update_scrolltext([get(S.hText,'UserData');'     --- Second median correction ----'],S.hText,S.hSlider);
            pause(0.0001);
            saved_image(:,:) = images(:,:,J);
            [h_lim, x_lim]                               = ecdf(reshape(images(:,:,J),size(images,1)*size(images,2),1));
            min_hist                                    = floor(x_lim(find(h_lim >= 0.02,1)));
            max_hist                                    =  ceil(x_lim(find(h_lim >= 0.98,1)));
        
            
            [images(:,:,J), peak_gaussian_std, peak_gaussian_ampl, improv_param]       = medianCorrection2(images(:,:,J), ...
                                                                                        peak_2_gaussian_std, peak_2_gaussian_ampl, ...
                                                                                        min_spacing_stdev(index,j), max_spacing_stdev(index,j), ...
                                                                                        amplitude_fract, ceil(min_peak_distance/mean(diff(position_est))), min_peak_height, peak_threshold, ...
                                                                                        position_est, peak_height_est, peak_index_est, ...
                                                                                        peak_pos_tolerance, histogram_bins, smoothing_level, ...
                                                                                        min_hist, max_hist, ref_peak_pos, peaks_fit(j),j,S,index);  % Med_corr_2
            
            images(:,:,J) = images(:,:,J)-median(reshape(images(:,:,J),size(images(:,:,J),1)*size(images(:,:,J),2),1));
            if S.processAll  ==  0          % process only one image 
                med_corr_2_images(:,:,J) = images(:,:,J); % Saves the raw image 
            end
        
            if plot_intermediate_steps == 1
                figure(summary_fig)
                subplot(2, 7, 5);
                plot_nice_image;
                title('After 2nd median correction')
                subplot(2, 7, 12); 
                image_inside_range                      = images(:,:,J);
                image_inside_range((images(:,:,J) < min_hist))   = NaN;                                                                                                              
                image_inside_range((images(:,:,J) > max_hist))   = NaN; 
                hist(reshape(image_inside_range(:,:),size(image_inside_range,1)*size(image_inside_range,2),1),histogram_bins);
                
                title('Histogram')
            end
          
             if max(peak_gaussian_ampl) >  max_peak_ampl
                max_peak_ampl           = max(peak_gaussian_ampl);
             end
        
            if improv_param < 0
                update_scrolltext([get(S.hText,'UserData');'          This step did NOT improve the image'],S.hText,S.hSlider);
                pause(0.0001);
%dlmwrite([ImageDir,get(S.baseDirectoryText,'string'),filesep,'Figure PNGS',filesep,channel_info(J).Name,filesep,'text',filesep,'F ',tok,remain(2:4),' 2 med fail.txt'],imresize(images(:,:,J),[max(size(images(:,:,J))),max(size(images(:,:,J)))]),'delimiter', '\t','precision', 5);
                images(:,:,J)                       = saved_image(:,:);
                peak_gaussian_std                   = peak_2_gaussian_std;
                peak_gaussian_ampl                  = peak_2_gaussian_ampl;
                if plot_intermediate_steps == 1
                    xlabel('This step did NOT improve the image');
                end
            elseif improv_param == 0                     
                if plot_intermediate_steps == 1
                    xlabel('          No change')
                end
            else
                if Calc_flatten_lim(j) == 1
                if length(peak_gaussian_std) >= peaks_fit(j)
                    max_spacing_stdev(index,j)                        = 1.25*peak_gaussian_std(peaks_fit(j));
                    min_spacing_stdev(index,j)                        = 0.25*peak_gaussian_std(peaks_fit(j));
                else
                    max_spacing_stdev(index,j)                        = 1.25*peak_gaussian_std(1);
                    min_spacing_stdev(index,j)                        = 0.25*peak_gaussian_std(1);
                end
                end
                update_scrolltext([get(S.hText,'UserData');'          This step improved the image'],S.hText,S.hSlider);
                pause(0.0001);
                if plot_intermediate_steps == 1
                    xlabel('This step improved the image');
                end
%dlmwrite([ImageDir,get(S.baseDirectoryText,'string'),filesep,'Figure PNGS',filesep,channel_info(J).Name,filesep,'text',filesep,'F ',tok,remain(2:4),' 2 med improv.txt'],imresize(images(:,:,J),[max(size(images(:,:,J))),max(size(images(:,:,J)))]),'delimiter', '\t','precision', 5);
            end
        
        offset_sub                                  = median(reshape(images(:,:,J),size(images(:,:,J),1)*size(images(:,:,J),2),1));
        images(:,:,J)                               = images(:,:,J) - offset_sub;
            
        end

%% This does a second round of thresholding and polynomial flattening to improve on the results from before.
        saved_image                                         = images(:,:,J);
        [h_lim, x_lim]                                       = ecdf(reshape(images(:,:,J),size(images,1)*size(images,2),1));
        mask_z_min                                          = floor(x_lim(find(h_lim >= 0.03,1)));
        mask_z_max                                          =  ceil(x_lim(find(h_lim >= 0.97,1)));
        
        image_inside_range                                  = images(:,:,J);
        image_inside_range((images(:,:,J) < mask_z_min))    = NaN;                                                                                                              
        image_inside_range((images(:,:,J) > mask_z_max))    = NaN; 
          
        [gaussian_fit, ~, peaks_nb,~,~]                         = fit_multi_gauss(image_inside_range,index,j,S,min_spacing_stdev_user,max_spacing_stdev_user,amplitude_fract,smoothing_level);
                                                           
                                               
         for i                                              = 1:peaks_nb       % Detects peaks smaller than min_peak_height; peaks found by findpeaks are bigger than this value, but if gaussian fit not good, peaks smaller can 'apppear'
             eval(['peak_ampl = gaussian_fit.a', num2str(i), ';']);
             if peak_ampl < min_peak_height
                 peaks_nb                                   = peaks_nb - 1;
             end
         end
         
        % Combines all the amplitudes, the positions and the standard
        % deviations into one vector and sets the lower and upper threshold
        % for all peaks
         gaussian_fit_ampl                       = [];
         gaussian_fit_pos                        = [];
         gaussian_fit_std                        = [];
         for i = 1:peaks_nb
            eval(['gaussian_fit_ampl(', num2str(i), ')= gaussian_fit.a', num2str(i), ';']);
            eval(['gaussian_fit_pos(' , num2str(i), ')= gaussian_fit.b', num2str(i), ';']);
            eval(['gaussian_fit_std(' , num2str(i), ')= gaussian_fit.c', num2str(i), ';']);
         end
       
         % For the overlap checking, sort the peaks in ascending order (in'peer',S.ax1,
         % term of position)
         if peaks_nb == 1
             peak_gaussian_pos                          = gaussian_fit_pos;
             peak_gaussian_std                          = gaussian_fit_std;
             peak_gaussian_ampl                         = gaussian_fit_ampl;
         else
             [peak_gaussian_pos, ind]                   = sort(gaussian_fit_pos, 'ascend');
             for i                                      = 1:peaks_nb
                peak_gaussian_std(i)                    = gaussian_fit_std(ind(i));
                peak_gaussian_ampl(i)                   = gaussian_fit_ampl(ind(i));
             end
         end
         
           % For each peak, calculates the lower and upper threshold
           for i = 1:min([3,peaks_nb])    
            eval(['thresh_low_',  num2str(i), ' = peak_gaussian_pos(', num2str(i), ') - thresh_range*peak_gaussian_std(', num2str(i), ');']);
            eval(['thresh_high_', num2str(i), ' = peak_gaussian_pos(', num2str(i), ') + thresh_range*peak_gaussian_std(', num2str(i), ');']);
           end

         % For each pair of peaks, look if they overlap and what is their
         % intersection point
         if peaks_nb                                    == 1                                                                                                                                              % Only one peak, so no problem of overlap
             % do nothing
         else
             for i                                      = 1:min([2,peaks_nb-1])               
                fct = @(x)(peak_gaussian_ampl(i)*exp(-(x-peak_gaussian_pos(i)).^2./(2*(peak_gaussian_std(i))^2))- peak_gaussian_ampl(i+1)*exp(-(x-peak_gaussian_pos(i+1)).^2./(2*(peak_gaussian_std(i+1))^2)));
                eval(['thresh_start_x = (thresh_low_', num2str(i), '+ thresh_high_', num2str(i+1), ')/2;']);
                [intersect_x, fval, exit_flag] = fzero(fct, thresh_start_x);                                                                                                         % Finds intersection of the two peaks
                if intersect_x > peak_gaussian_pos(i)+ 5*peak_gaussian_std(i) || intersect_x < peak_gaussian_pos(i) - 5*peak_gaussian_std(i)        % Wrong zero was found; it can happen when the intersection point is where the gaussian curves tend to zero
                exit_flag                               = 0;                                                                                                                      % Sets the exit_flag to a value different of 1 so it doesn't do anything
                end
                    if exit_flag                        == 1                                                                                                                                                         % An intersection point between the two peaks was found
                        if i == 1
                             if thresh_high_1           > intersect_x
                                thresh_high_1           = intersect_x;                                                                                                            % Sets the upper threshold of the first peak to the intersection position
                             end
                             if thresh_low_2            < intersect_x
                                thresh_low_2            = intersect_x;                                                                                                              % Sets the lower threshold of the second peak to the intersection position
                             end
                        end
                         if i == 2       % (i can be equal to 1 or 2)
                             if thresh_high_2           > intersect_x
                                thresh_high_2           = intersect_x;                                                                                                            % Sets the upper threshold of the first peak to the intersection position
                             end
                             if thresh_low_3            < intersect_x
                                thresh_low_3            = intersect_x;                                                                                                              % Sets the lower threshold of the second peak to the intersection position
                             end  
                         end
                    end
             end
         end
         
         % Put the peaks in their originial order (largest amplitude first)
           
          for i = 1:min([3,peaks_nb-1])
              pause(0.0001)
                eval(['thresh_low(', num2str(i), ')     = thresh_low_', num2str(i), ';']);
                eval(['thresh_high(', num2str(i), ')    = thresh_high_', num2str(i), ';']);
          end
             
         % Set the lower and upper threshold of the peak to be flattened
         if peaks_nb >= peak_to_flatten(j)
             eval(['thresh_low = thresh_low_', num2str(peak_to_flatten(j)), ';']);
             eval(['thresh_high = thresh_high_', num2str(peak_to_flatten(j)), ';']);
         else
             thresh_low                             = thresh_low_1;
             thresh_high                            = thresh_high_1;
         end    
         
        image_test                                  = images(:,:,J);                                                                                                                    % Makes a duplicate of the image
        image_test((images(:,:,J) < thresh_low))    = NaN;                                                                                                                              % Thresholds data below
        image_test((images(:,:,J) > thresh_high))   = NaN;                                                                                                                              % Thresholds data above

        
% % Plot Corrected Data within the mask      
% figure ('Name','Second Poly Mask')
% subplot(2,1,1); 
% imshow(image_test,[thresh_low thresh_high]);
% colormap(mycmap_sky); 
% colorbar;
% subplot(2,1,2);
% plot(position_final',height_final);
% hold on;
% plot(gaussian_fit,'r');
% hold off;                                                  
% axis square;
% axis tight;
        
        
        
        
        Second_Thresh_File = [ImageDir,get(S.baseDirectoryText,'string'),filesep,'second_threshold.txt'];
        if  index == 1 && j == 1  
            fid = fopen(Second_Thresh_File, 'a');
            fprintf(fid, [  'Image','\t',...
                            'Channel','\t',...
                            'Thresh Low','\t',...
                            'Thresh High','\n'],...
                            'char');

            fprintf(fid, [  num2str(file_number,'%0.0f'),'\t',...
                            channel_info(J).Name,'\t',...
                            num2str(thresh_low,'%0.0f'),'\t',...
                            num2str(thresh_high,'%0.3f'),'\n'],...
                            'char');
            fclose(fid);
        else
            fid = fopen(Second_Thresh_File, 'a');
            fprintf(fid, [  num2str(file_number,'%0.0f'),'\t',...
                            channel_info(J).Name,'\t',...
                            num2str(thresh_low,'%0.0f'),'\t',...
                            num2str(thresh_high,'%0.3f'),'\n'],...
                            'char');
            fclose(fid);
        end
    
            
        % Fit the thresholded surface to an n x m polynomial 
        %coef_length                                     = nchoosek(max([poly_order_horiz(j),poly_order_vert(j)])+2,2);                                                                      % Calculates the number of coeffecients
        [xInput_poly, yInput_poly, zOutput_poly]        = prepareSurfaceData(1:size(images(:,:,J),1),1:size(images(:,:,J),2) , image_test);                                                 % Preps vectors for surface fitting
        poly_type                                       = fittype( ['poly',num2str(poly_order_vert(j)),num2str(poly_order_horiz(j))] );                                                     % Sets the fit type to be an X-Y polynomial       
        poly_opts                                       = fitoptions( poly_type );                                                                                                          % Tells it to fit a polynomial
        coef_length                                     = numcoeffs(poly_type);
        if index<= 2
            poly_opts.Lower                             = -Inf*ones(coef_length,1);                                                                                                         % Sets the lower bounds
            poly_opts.Upper                             =  Inf*ones(coef_length,1);                                                                                                         % Sets the upper bounds
        else
            poly_opt.Lower                              = coeffvalues(Third_poly_coef{index-1,j})-0.5*abs(coeffvalues(Third_poly_coef{index-1,j}));
            poly_opt.Upper                              = coeffvalues(Third_poly_coef{index-1,j})+0.5*abs(coeffvalues(Third_poly_coef{index-1,j}));
        end                                                                                                       % Sets the upper bounds
        
        poly_result                                     = fit( [xInput_poly, yInput_poly], zOutput_poly, poly_type, poly_opts );                                                            % Fits the polynomial to the actual data
        images(:,:,J)                                   = images(:,:,J) - reshape(poly_result([xInput,yInput]),size(images(:,:,J),1),size(images(:,:,J),2));
        Third_poly_coef{index,j}                        = poly_result;
        
        offset_sub                                      = median(reshape(images(:,:,J),size(images(:,:,J),1)*size(images(:,:,J),2),1));
        images(:,:,J)                                   = images(:,:,J) - offset_sub;
        thresh_low                                      = thresh_low    - offset_sub;
        thresh_high                                     = thresh_high   - offset_sub;

        
        if S.processAll                                 ==  0               % process only one image 
            poly_flat_2_images(:,:,J) = images(:,:,J);    % Saves the raw image 
        end

        if plot_intermediate_steps == 1
            figure(summary_fig)
            subplot(2, 7, 6);
            plot_nice_image;
            title('After 2nd polynomial flattening')
            subplot(2, 7, 13); 
            image_inside_range                                  = images(:,:,J);
            image_inside_range((images(:,:,J) < min_hist))      = NaN;                                                                                                              
            image_inside_range((images(:,:,J) > max_hist))      = NaN; 
            hist(reshape(image_inside_range(:,:),size(image_inside_range,1)*size(image_inside_range,2),1),histogram_bins);
            
            title('Histogram')
            xlabel('This step improved the image');
        end
       
        
        % Checks if the polynomial flattening brought some improvement or
        % not 
        update_scrolltext([get(S.hText,'UserData');'     --- Second Poly Flattening ----'],S.hText,S.hSlider);
        pause(0.0001);
        [improv_param_thresh2, peak_gaussian_std, peak_gaussian_ampl] = check_improvement(images(:,:,J), ...
                                                                    gaussian_fit_std, gaussian_fit_ampl,...
                                                                    min_spacing_stdev(index,j), max_spacing_stdev(index,j), ...
                                                                    amplitude_fract,  ceil(min_peak_distance/mean(diff(position_est))), min_peak_height, peak_threshold, ...
                                                                    position_est, peak_height_est, peak_index_est, ...
                                                                    peak_pos_tolerance, histogram_bins, smoothing_level, ...
                                                                    min_hist, max_hist, ref_peak_pos, peaks_fit(j),j,S,index);
    
        if max(peak_gaussian_ampl)                              > max_peak_ampl
            max_peak_ampl                                       = max(peak_gaussian_ampl);
        end
        if improv_param_thresh2 < 0                         % If true, the polynomial flattening didn't bring an improvement
%dlmwrite([ImageDir,get(S.baseDirectoryText,'string'),filesep,'Figure PNGS',filesep,channel_info(J).Name,filesep,'text',filesep,'G ',tok,remain(2:4),' 2nd poly fail.txt'],imresize(images(:,:,J),[max(size(images(:,:,J))),max(size(images(:,:,J)))]),'delimiter', '\t','precision', 5);
            images(:,:,J)                                       = saved_image;            % Cancels the polynomial flattening
            peak_gaussian_std                                   = gaussian_fit_std;    
            peak_gaussian_ampl                                  = gaussian_fit_ampl;
            update_scrolltext([get(S.hText,'UserData');'          The second polymomial flattening did NOT improve the image'],S.hText,S.hSlider);
            pause(0.0001);
            if plot_intermediate_steps == 1
                figure(summary_fig)
                xlabel('This step did NOT improve the image')
            end
        else
            max_spacing_stdev(index,j)                        = 1.25*peak_gaussian_std(min([peaks_fit(j),length(peaks_fit(j))]));
            min_spacing_stdev(index,j)                        = 0.25*peak_gaussian_std(min([peaks_fit(j),length(peaks_fit(j))]));
            update_scrolltext([get(S.hText,'UserData');'          The second polymomial flattening improved the image'],S.hText,S.hSlider);
            pause(0.0001);
%dlmwrite([ImageDir,get(S.baseDirectoryText,'string'),filesep,'Figure PNGS',filesep,channel_info(J).Name,filesep,'text',filesep,'G ',tok,remain(2:4),' 2nd poly win.txt'],imresize(images(:,:,J),[max(size(images(:,:,J))),max(size(images(:,:,J)))]),'delimiter', '\t','precision', 5);
        end
        if improv_param_thresh2 == 0 && plot_intermediate_steps == 1     
            figure(summary_fig)
            xlabel('No change')
        end

%% Calculates the Final Mask        
        [h_lim, x_lim]                                       = ecdf(reshape(images(:,:,J),size(images,1)*size(images,2),1));
        mask_z_min                                          = floor(x_lim(find(h_lim >= 0.03,1)));
        mask_z_max                                          =  ceil(x_lim(find(h_lim >= 0.97,1)));
        
        image_inside_range                                  = images(:,:,J);
        image_inside_range((images(:,:,J) < mask_z_min))    = NaN;                                                                                                              
        image_inside_range((images(:,:,J) > mask_z_max))    = NaN; 

        [gaussian_fit, ~, n_peaks,~,~]                          = fit_multi_gauss(image_inside_range,index,j,S,min_spacing_stdev_user,max_spacing_stdev_user,amplitude_fract,smoothing_level);

                                   
         peaks_nb                                           = n_peaks;
         for i                                              = 1:n_peaks       % Detects peaks smaller than min_peak_height; peaks found by findpeaks are bigger than this value, but if gaussian fit not good, peaks smaller can 'apppear'
             eval(['peak_ampl = gaussian_fit.a', num2str(i), ';']);
             if peak_ampl < min_peak_height
                 peaks_nb                                   = peaks_nb - 1;
             end
         end
         
        % Combines all the amplitudes, the positions and the standard
        % deviations into one vector and sets the lower and upper threshold
        % for all peaks
         gaussian_fit_ampl                                  = [];
         gaussian_fit_pos                                   = [];
         gaussian_fit_std                                   = [];
         for i = 1:peaks_nb
            eval(['gaussian_fit_ampl(', num2str(i), ')= gaussian_fit.a', num2str(i), ';']);
            eval(['gaussian_fit_pos(' , num2str(i), ')= gaussian_fit.b', num2str(i), ';']);
            eval(['gaussian_fit_std(' , num2str(i), ')= gaussian_fit.c', num2str(i), ';']);
         end
       
         % For the overlap checking, sort the peaks in ascending order (in
         % term of position)
         if peaks_nb == 1
             peak_gaussian_pos                              = gaussian_fit_pos;
             peak_gaussian_std                              = gaussian_fit_std;
             peak_gaussian_ampl                             = gaussian_fit_ampl;
         else
             [peak_gaussian_pos, ind]                       = sort(gaussian_fit_pos, 'ascend');
             for i                                          = 1:peaks_nb
                peak_gaussian_std(i)                        = gaussian_fit_std(ind(i));
                peak_gaussian_ampl(i)                       = gaussian_fit_ampl(ind(i));
             end
         end
         
           % For each peak, calculates the lower and upper threshold
           for i = 1:peaks_nb     
            eval(['thresh_low_',  num2str(i), ' = peak_gaussian_pos(', num2str(i), ') - thresh_range*peak_gaussian_std(', num2str(i), ');']);
            eval(['thresh_high_', num2str(i), ' = peak_gaussian_pos(', num2str(i), ') + thresh_range*peak_gaussian_std(', num2str(i), ');']);
           end

         % For each pair of peaks, look if they overlap and what is their
         % intersection point
         if peaks_nb                                    == 1                                                                                                                                              % Only one peak, so no problem of overlap
             % do nothing
         else
             for i                                      = 1:peaks_nb-1               
                 fct = @(x)(peak_gaussian_ampl(i)*exp(-(x-peak_gaussian_pos(i)).^2./(2*(peak_gaussian_std(i))^2))- peak_gaussian_ampl(i+1)*exp(-(x-peak_gaussian_pos(i+1)).^2./(2*(peak_gaussian_std(i+1))^2)));
                 eval(['thresh_start_x = (thresh_low_', num2str(i), '+ thresh_high_', num2str(i+1), ')/2;']);
                [intersect_x, fval, exit_flag] = fzero(fct, thresh_start_x);                                                                                                         % Finds intersection of the two peaks
                if intersect_x > peak_gaussian_pos(i)+ 5*peak_gaussian_std(i) || intersect_x < peak_gaussian_pos(i) - 5*peak_gaussian_std(i)        % Wrong zero was found; it can happen when the intersection point is where the gaussian curves tend to zero
                exit_flag                               = 0;                                                                                                                      % Sets the exit_flag to a value different of 1 so it doesn't do anything
                end
                    if exit_flag                        == 1                                                                                                                                                         % An intersection point between the two peaks was found
                        if i == 1
                             if thresh_high_1           > intersect_x
                                thresh_high_1           = intersect_x;                                                                                                            % Sets the upper threshold of the first peak to the intersection position
                             end
                             if thresh_low_2            < intersect_x
                                thresh_low_2            = intersect_x;                                                                                                              % Sets the lower threshold of the second peak to the intersection position
                             end
                        end
                         if i == 2       % (i can be equal to 1 or 2)
                             if thresh_high_2           > intersect_x
                                thresh_high_2           = intersect_x;                                                                                                            % Sets the upper threshold of the first peak to the intersection position
                             end
                             if thresh_low_3            < intersect_x
                                thresh_low_3            = intersect_x;                                                                                                              % Sets the lower threshold of the second peak to the intersection position
                             end  
                         end
                    end
             end
         end
         
         % Put the peaks in their originial order (largest amplitude first)
           for i = 1:peaks_nb 
                eval(['thresh_low(', num2str(i), ')     = thresh_low_', num2str(i), ';']);
                eval(['thresh_high(', num2str(i), ')    = thresh_high_', num2str(i), ';']);
           end
             
         % Set the lower and upper threshold of the peak to be flattened
         if peaks_nb >= peak_to_flatten(j)
             eval(['thresh_low = thresh_low_', num2str(peak_to_flatten(j)), ';']);
             eval(['thresh_high = thresh_high_', num2str(peak_to_flatten(j)), ';']);
         else
             thresh_low                             = thresh_low_1;
             thresh_high                            = thresh_high_1;
         end    
         
        image_test                                  = images(:,:,J);                                                                                                                    % Makes a duplicate of the image
        image_test((images(:,:,J) < thresh_low))    = NaN;                                                                                                                              % Thresholds data below
        image_test((images(:,:,J) > thresh_high))   = NaN;
        
    
%dlmwrite([ImageDir,get(S.baseDirectoryText,'string'),filesep,'Figure PNGS',filesep,channel_info(J).Name,filesep,'text',filesep,'H ',tok,remain(2:4),' final mask.txt'],imresize(isfinite(image_test),[max(size(images(:,:,J))),max(size(images(:,:,J)))]),'delimiter', '\t','precision', 5);

%% Computes the final mask for direct one-step correction of the initial image (image after first median correction)
        update_scrolltext([get(S.hText,'UserData');'     --- Calculating 1D Offset Corrections ----'],S.hText,S.hSlider);
        pause(0.0001);
        image_temp                                          = raw_images(:,:,J);
        masked_data                                         = nan(size(image_temp));
        for aa                                              = 1:size(image_temp,1)
            for bb                                          = 1:size(image_temp,2)
                if ~isnan(image_test(aa,bb))
                    masked_data(aa,bb)                      = image_temp(aa,bb);   
                else
                    masked_data(aa,bb)                      = NaN;
                end
            end
        end

        mask_offset                                         = reshape(masked_data,size(masked_data,1)*size(masked_data,2),1);
        mask_offset                                         = median(mask_offset(~isnan(mask_offset)));
        masked_data                                         = masked_data - mask_offset;

% %Plot Corrected Data within the mask
% figure('Name','Masked Raw Data')
% imshow(masked_data,[min(min(image_temp)) max(max(image_temp))]);
% colormap(mycmap_sky); 
% colorbar;
        
        if poly_order_vert(j) >= 1 || poly_order_horiz(j) >= 1
            %coef_length                                     = nchoosek(max([poly_order_horiz(j),poly_order_vert(j)])+2,2);                                                                      % Calculates the number of coeffecients
            [xInput_poly, yInput_poly, zOutput_poly]        = prepareSurfaceData(1:size(images(:,:,J),1),1:size(images(:,:,J),2), masked_data);                                                 % Preps vectors for surface fitting
            poly_type                                       = fittype( ['poly',num2str(poly_order_vert(j)),num2str(poly_order_horiz(j))] );                                                     % Sets the fit type to be an X-Y polynomial
            poly_opts                                       = fitoptions( poly_type );                                                                                                          % Tells it to fit a polynomial
            coef_length                                     = numcoeffs(poly_type);
            if index<= 2
                poly_opts.Lower                             = -Inf*ones(coef_length,1);                                                                                                         % Sets the lower bounds
                poly_opts.Upper                             =  Inf*ones(coef_length,1);                                                                                                         % Sets the upper bounds
            else
                poly_opt.Lower                              = coeffvalues(Third_poly_coef{index-1,j})-0.5*abs(coeffvalues(Third_poly_coef{index-1,j}));
                poly_opt.Upper                              = coeffvalues(Third_poly_coef{index-1,j})+0.5*abs(coeffvalues(Third_poly_coef{index-1,j}));
            end                                                                                                       % Sets the upper bounds

            poly_result                                     = fit( [xInput_poly, yInput_poly], zOutput_poly, poly_type, poly_opts );                                                            % Fits the polynomial to the actual data

            % Resets the coeffectients to the sum of all the previous
            % corrections  This has to account for corrections were applied
            % to the data.  If a correction was turned off, these
            % coeffecients need to be set to zero.
            

                coef_1                                      =  zeros(size(Init_poly_coef{index,j}));
            if improv_param_thresh2                         > 0
                coef_2                                      = coeffvalues(Second_poly_coef{index,j});
            else
                coef_2                                      =  zeros(size(Second_poly_coef{index,j}));
            end
            if improv_param_thresh2                         > 0
                coef_3                                      = coeffvalues(Third_poly_coef{index,j});
            else
                coef_3                                      =  zeros(size(Third_poly_coef{index,j}));
            end
             
            coef_total                                      = zeros(1,max([length(coef_1),length(coef_2),length(coef_3)]));
            for aa                                          = 1:max([length(coef_1),length(coef_2),length(coef_3)])
                if aa <= length(coef_1) && aa <= length(coef_2) && aa <= length(coef_3)
                    coef_total(aa)                          = coef_1(aa) + coef_2(aa) + coef_3(aa); 
                elseif aa <= length(coef_1) && aa <= length(coef_2) && aa > length(coef_3)
                    coef_total(aa)                          = coef_1(aa) + coef_2(aa);
                elseif aa <= length(coef_1) && aa > length(coef_2) && aa <= length(coef_3)
                    coef_total(aa)                          = coef_1(aa) + coef_3(aa);
                elseif aa > length(coef_1) && aa <= length(coef_2) && aa <= length(coef_3)
                    coef_total(aa)                          = coef_2(aa) + coef_3(aa);
                elseif aa <= length(coef_1) && aa > length(coef_2) && aa > length(coef_3)
                    coef_total(aa)                          = coef_1(aa);
                elseif aa > length(coef_1) && aa <= length(coef_2) && aa > length(coef_3)
                    coef_total(aa)                          = coef_2(aa);
                elseif aa > length(coef_1) && aa > length(coef_2) && aa <= length(coef_3)
                    coef_total(aa)                          = coef_3(aa);
                end
            end
           Poly_result.Coefficients                        = coef_total;
           poly_background_sub                             = reshape(poly_result([xInput,yInput]),size(images(:,:,J),1),size(images(:,:,J),2));
           masked_data                                     = masked_data     - poly_background_sub;
           mask_offset                                     = reshape(masked_data,size(masked_data,1)*size(masked_data,2),1);
           mask_offset                                     = median(mask_offset(~isnan(mask_offset)));
           masked_data                                     = masked_data - mask_offset;
%            image_temp                                      = image_temp - poly_background_sub;
%            image_temp                                      = image_temp - median(reshape(image_temp,size(image_temp,1)*size(image_temp,2),1));
%         
        end
% % Plot Corrected Data within the mask
%         figure('Name','Mask,Prior Poly Subtracted')
%         imshow(masked_data + z_height_reference(j),[min_z(j) max_z(j)]);
%         colormap(mycmap_sky); 
%         colorbar;
%         
% % Plot Full Corrected Data
%         figure('Name','Full,Prior Poly Subtracted')
%         imshow(image_temp,[min_z(j) max_z(j)]);
%         colormap(mycmap_sky); 
%         colorbar;
%dlmwrite([ImageDir,get(S.baseDirectoryText,'string'),filesep,'Figure PNGS',filesep,channel_info(J).Name,filesep,'text',filesep,'I ',tok,remain(2:4),' cumulative Background subtracted from raw.txt'],imresize(image_temp,[max(size(images(:,:,J))),max(size(images(:,:,J)))]),'delimiter', '\t','precision', 5);

% Make offset calculated in the mask set match with the full data
        [masked_data, line_median1]                         = medianCorrection_mask_test(masked_data);
%         for aa                                              = 1:size(masked_data,1)
%            image_temp(aa,:)                                 = image_temp(aa,:)-line_median1(aa); 
%         end
%         image_temp                                         = image_temp - median(reshape(image_temp,size(image_temp,1)*size(image_temp,2),1));

% % Plot Corrected Data within the mask
%         figure ('Name','Mask, After Mask Median')
%         imshow(masked_data + z_height_reference(j),[min_z(j) max_z(j)]);
%         colormap(mycmap_sky); 
%         colorbar;
         
% % Plot Full Corrected Data
%         figure ('Name','Full, After Mask Median')
%         imshow(image_temp,[min(min(image_temp)) max(max(image_temp))]);
%         colormap(mycmap_sky);
%         colorbar;
%dlmwrite([ImageDir,get(S.baseDirectoryText,'string'),filesep,'Figure PNGS',filesep,channel_info(J).Name,filesep,'text',filesep,'J ',tok,remain(2:4),' Masked Median 1.txt'],imresize(image_temp,[max(size(images(:,:,J))),max(size(images(:,:,J)))]),'delimiter', '\t','precision', 5);

%Fit the thresholded surface to an n x m polynomial
        %coef_length                                     = nchoosek(max([poly_order_horiz(j),poly_order_vert(j)])+2,2);                                                                      % Calculates the number of coeffecients
        [xInput_poly, yInput_poly, zOutput_poly]        = prepareSurfaceData(1:size(images(:,:,J),1),1:size(images(:,:,J),2), masked_data);                                                 % Preps vectors for surface fitting
        poly_type                                       = fittype( ['poly',num2str(poly_order_vert(j)),num2str(poly_order_horiz(j))] );                                                     % Sets the fit type to be an X-Y polynomial
        poly_opts                                       = fitoptions( poly_type );                                                                                                          % Tells it to fit a polynomial
        coef_length                                     = numcoeffs(poly_type);
        if index<= 2
            poly_opts.Lower                             = -Inf*ones(coef_length,1);                                                                                                         % Sets the lower bounds
            poly_opts.Upper                             =  Inf*ones(coef_length,1);                                                                                                         % Sets the upper bounds
        else
            poly_opt.Lower                              = coeffvalues(Third_poly_coef{index-1,j})-0.5*abs(coeffvalues(Third_poly_coef{index-1,j}));
            poly_opt.Upper                              = coeffvalues(Third_poly_coef{index-1,j})+0.5*abs(coeffvalues(Third_poly_coef{index-1,j}));
        end                                                                                                       % Sets the upper bounds

        poly_result                                     = fit( [xInput_poly, yInput_poly], zOutput_poly, poly_type, poly_opts );                                                            % Fits the polynomial to the actual data
        
       poly_background_sub                             = reshape(poly_result([xInput,yInput]),size(images(:,:,J),1),size(images(:,:,J),2));
       masked_data                                     = masked_data - poly_background_sub;
       mask_offset                                     = reshape(masked_data,size(masked_data,1)*size(masked_data,2),1);
       mask_offset                                     = median(mask_offset(~isnan(mask_offset)));
       masked_data                                     = masked_data - mask_offset;
%        image_temp                                      = image_temp  - poly_background_sub;
%        image_temp                                      = image_temp - median(reshape(image_temp,size(image_temp,1)*size(image_temp,2),1));
%             
% % Plot Corrected Data within the mask
%         figure ('Name','Mask, After Final Poly')
%         imshow(masked_data + z_height_reference(j),[min_z(j) max_z(j)]);
%         colormap(mycmap_sky); 
%         colorbar;
        
% % Plot Full Corrected Data
%         figure ('Name','Full, After Final Poly')
%         imshow(image_temp ,[min_z(j) max_z(j)]);
%         colormap(mycmap_sky);
%         colorbar;
%dlmwrite([ImageDir,get(S.baseDirectoryText,'string'),filesep,'Figure PNGS',filesep,channel_info(J).Name,filesep,'text',filesep,'K ',tok,remain(2:4),' Masked Flattening.txt'],imresize(image_temp,[max(size(images(:,:,J))),max(size(images(:,:,J)))]),'delimiter', '\t','precision', 5);

% % Make offset calculated in the mask set match with the full data
        [~, line_median2]                               = medianCorrection_mask_test(masked_data);
%         for aa                                          = 1:size(masked_data,1)
%            image_temp(aa,:)                             = image_temp(aa,:)-line_median2(aa); 
%         end
%         image_temp                                      = image_temp - median(reshape(image_temp,size(image_temp,1)*size(image_temp,2),1));

% % Plot Corrected Data within the mask
%         figure ('Name','Mask, After Mask Median2')
%         imshow(masked_data + z_height_reference(j),[min_z(j) max_z(j)]);
%         colormap(mycmap_sky); 
%         colorbar;
        
% % Plot Full Corrected Data
%         figure ('Name','Full, After Mask Median2')
%         imshow(image_temp ,[min_z(j) max_z(j)]);
%         colormap(mycmap_sky);        
%         colorbar;
%dlmwrite([ImageDir,get(S.baseDirectoryText,'string'),filesep,'Figure PNGS',filesep,channel_info(J).Name,filesep,'text',filesep,'L ',tok,remain(2:4),' Masked Median 2.txt'],imresize(image_temp,[max(size(images(:,:,J))),max(size(images(:,:,J)))]),'delimiter', '\t','precision', 5);


% Do the final offset subtraction from the raw data followed by the masked
% fitting
        update_scrolltext([get(S.hText,'UserData');'     --- Final 2D Polynomial Fitting ----'],S.hText,S.hSlider);
        pause(0.0001);
        image_temp                                     = raw_images(:,:,J);
        masked_data                                    = nan(size(image_temp));
        for aa                                         = 1:size(image_temp,1)
            for bb                                     = 1:size(image_temp,2)
                if ~isnan(image_test(aa,bb))
                    masked_data(aa,bb)                 = image_temp(aa,bb);   
                else
                    masked_data(aa,bb)                 = NaN;
                end
            end
        end

        mask_offset                                    = reshape(masked_data,size(masked_data,1)*size(masked_data,2),1);
        mask_offset                                    = median(mask_offset(~isnan(mask_offset)));
        masked_data                                    = masked_data - mask_offset;

       for aa                                          = 1:size(masked_data,1)
           masked_data(aa,:)                           = masked_data(aa,:)- line_median1(aa)-line_median2(aa);
           image_temp(aa,:)                            = image_temp(aa,:)- line_median1(aa)-line_median2(aa);
       end
       image_temp                                      = image_temp - median(reshape(image_temp,size(image_temp,1)*size(image_temp,2),1));

       
% %Plot All Offsets Removed
%         z_low                                           = min(min(masked_data));
%         z_high                                          = max(max(masked_data));  
%         figure ('Name','All offsets removed')
%         imshow(masked_data,[min(min(image_temp)) max(max(image_temp))]);
%         colormap(mycmap_sky);        
%         colorbar;

% % Plot All Offsets Removed
%         z_low                                           = min(min(masked_data));
%         z_high                                          = max(max(masked_data));  
%         figure ('Name','All offsets removed')
%         imshow(image_temp,[min(min(image_temp)) max(max(image_temp))]);
%         colormap(mycmap_sky);        
%         colorbar;
%dlmwrite([ImageDir,get(S.baseDirectoryText,'string'),filesep,'Figure PNGS',filesep,channel_info(J).Name,filesep,'text',filesep,'N ',tok,remain(2:4),' Raw minus Final Offset.txt'],imresize(image_temp,[max(size(images(:,:,J))),max(size(images(:,:,J)))]),'delimiter', '\t','precision', 5);

 %Fit the thresholded surface to an n x m polynomial
        %coef_length                                     = nchoosek(max([poly_order_horiz(j),poly_order_vert(j)])+2,2);                                                                      % Calculates the number of coeffecients
        [xInput_poly, yInput_poly, zOutput_poly]        = prepareSurfaceData(1:size(images(:,:,J),1),1:size(images(:,:,J),2), masked_data);                                                 % Preps vectors for surface fitting
        poly_type                                       = fittype( ['poly',num2str(poly_order_vert(j)),num2str(poly_order_horiz(j))] );                                                     % Sets the fit type to be an X-Y polynomial
        poly_opts                                       = fitoptions( poly_type );                                                                                                          % Tells it to fit a polynomial
        coef_length                                     = numcoeffs(poly_type);
        if index<= 2
            poly_opts.Lower                             = -Inf*ones(coef_length,1);                                                                                                         % Sets the lower bounds
            poly_opts.Upper                             =  Inf*ones(coef_length,1);                                                                                                         % Sets the upper bounds
        else
            poly_opt.Lower                              = coeffvalues(Third_poly_coef{index-1,j})-0.5*abs(coeffvalues(Third_poly_coef{index-1,j}));
            poly_opt.Upper                              = coeffvalues(Third_poly_coef{index-1,j})+0.5*abs(coeffvalues(Third_poly_coef{index-1,j}));
        end                                                                                                       % Sets the upper bounds

        poly_result                                     = fit( [xInput_poly, yInput_poly], zOutput_poly, poly_type, poly_opts );                                                            % Fits the polynomial to the actual data
        
        poly_background_sub                             = reshape(poly_result([xInput,yInput]),size(images(:,:,J),1),size(images(:,:,J),2));
        masked_data                                     = masked_data     - poly_background_sub;
        image_temp(:,:)                                 = image_temp(:,:) - poly_background_sub;
        
        mask_offset                                     = reshape(masked_data,size(masked_data,1)*size(masked_data,2),1);
        mask_offset                                     = median(mask_offset(~isnan(mask_offset)));
        masked_data                                     = masked_data - mask_offset;
        image_temp                                      = image_temp - median(reshape(image_temp,size(image_temp,1)*size(image_temp,2),1));


% % Plot Full Corrected Data
%         figure ('Name','Full Corrected Data')
%         imshow(image_temp + z_height_reference(j),[-200 200]);
%         colormap(mycmap_sky);        
%         colorbar;
%          
% Do the vertical median correction if turned on         
        if vert_med_corr(j) == 1                                                                                                                                                   % Allows user to turn median correction on or off  
            update_scrolltext([get(S.hText,'UserData');'     --- Vertical median correction ----'],S.hText,S.hSlider);
            pause(0.0001);
            
            masked_data_v                               = medianCorrection_mask_test(masked_data');                                                                                                                    
            image_temp_v                                = image_temp';
            for aa                                      = 1:size(masked_data_v,1)
                image_temp_v(aa,:)                      = image_temp_v(aa,:)-median(image_temp_v(aa,~isnan(masked_data_v(aa,:)))-masked_data_v(aa,~isnan(masked_data_v(aa,:))));
            end

            mask_offset_v                               = reshape(masked_data_v,size(masked_data_v,1)*size(masked_data_v,2),1);
            mask_offset_v                               = median(mask_offset_v(~isnan(mask_offset_v)));
            
            if sum(sum(isnan(image_temp_v))) == 0
            masked_data                                 = masked_data_v' - mask_offset_v;
            image_temp                                  = image_temp_v' - median(reshape(image_temp_v',size(image_temp_v',1)*size(image_temp_v',2),1));
            else
            end
        end   

%dlmwrite([ImageDir,get(S.baseDirectoryText,'string'),filesep,'Figure PNGS',filesep,channel_info(J).Name,filesep,'text',filesep,'O ',tok,remain(2:4),' Final Masked Flattening.txt'],imresize(image_temp,[max(size(images(:,:,J))),max(size(images(:,:,J)))]),'delimiter', '\t','precision', 5);

% Correct Any Residual Scars in the Image
% update_scrolltext([get(S.hText,'UserData');'     --- Scar Correction ----'],S.hText,S.hSlider);
% pause(0.0001);
% diff_line_median                                        = NaN(1,size(image_temp,1)-1);
% for aa                                                  = 1:size(image_temp,1)-1
%     diff_line_median(aa)                                = median(image_temp(aa+1,:)-image_temp(aa,:));
% end
% 
% for aa                                                  = 3:length(diff_line_median)
%     if abs(diff_line_median(aa))                        >= median(diff_line_median)+5*std(diff_line_median)
%         image_temp(aa,:)                                = image_temp(aa-2,:);
%     end
%     if  isnan(diff_line_median(aa))
%         image_temp(aa-1,:)                              = image_temp(aa-2,:);
%         image_temp(aa,:)                                = image_temp(aa-1,:);
%     end
% end    
% Write the Fitted Data to the final image file


images(:,:,J)                                           = image_temp;
%% Applies an offset to the whole image to put the reference peak at a given height reference_height
            update_scrolltext([get(S.hText,'UserData');'     --- Offsetting Image to Reference Height ----'],S.hText,S.hSlider);
            %pause(0.0001);
            [h_lim, x_lim]                                   = ecdf(reshape(images(:,:,J),size(images,1)*size(images,2),1));
            min_hist                                        = floor(x_lim(find(h_lim >= 0.02,1)));
            max_hist                                        =  ceil(x_lim(find(h_lim >= 0.98,1)));
            image_inside_range                              = images(:,:,J);
            image_inside_range((images(:,:,J) < min_hist))  = NaN;                                                                                                              
            image_inside_range((images(:,:,J) > max_hist))  = NaN; 
            
            [gaussian_fit, gaussian_gof, n_peaks,off_pos,off_height]           = fit_multi_gauss(image_inside_range,index,j,S,min_spacing_stdev_user,max_spacing_stdev_user,amplitude_fract,smoothing_level);

        % Combines all the amplitudes, the positions and the standard
        % deviations into one vector and sets the lower and upper threshold
        % for all peaks
         gaussian_fit_ampl                            = [];
         gaussian_fit_pos                             = [];
         gaussian_fit_std                             = [];
         for i = 1:n_peaks
            eval(['gaussian_fit_ampl(', num2str(i), ')= gaussian_fit.a', num2str(i), ';']);
            eval(['gaussian_fit_pos(', num2str(i), ')= gaussian_fit.b', num2str(i), ';']);
            eval(['gaussian_fit_std(', num2str(i), ')= gaussian_fit.c', num2str(i), ';']);
         end
         
         [peak_hist_pos, ind]       = sort(gaussian_fit_pos, 'ascend');
         peak_hist_ampl             = zeros(1,length(peak_hist_pos));
         for i                      = 1:length(peak_hist_pos)
                peak_hist_ampl(i)   = gaussian_fit_ampl(ind(i));
         end
          
        
         if length(peak_hist_pos) >= peak_reference_height(j)
                eval(['gaussian_fit_x_ref = peak_hist_pos(', num2str(peak_reference_height(j)), ');']); 
         elseif peak_reference_height(j) > 1 && length(peak_hist_pos) >= peak_reference_height(j)-1
                eval(['gaussian_fit_x_ref = peak_hist_pos(', num2str(peak_reference_height(j)-1), ');']);
         else
                gaussian_fit_x_ref = peak_hist_pos(1);
         end
        
        images(:,:,J)                                       = images(:,:,J) + z_height_reference(j) - gaussian_fit_x_ref;                           % Sets first peak to reference height                                                                                         % Adds the user selected Z-offset
        image_inside_range                                  = images(:,:,J);
        image_inside_range((images(:,:,J) < min_hist))      = NaN;
        image_inside_range((images(:,:,J) > max_hist))      = NaN;
        [height_final, position_final]                       = hist(reshape(image_inside_range(:,:),size(image_inside_range,1)*size(image_inside_range,2),1),histogram_bins);          % Calculates the histogram of the corrected height data (First image only)
        height_final                                        = 100*height_final/sum(height_final);
        height_final                                        = smooth(height_final,smoothing_level,'loess');
        min_peak_height                                     = min([min_peak_height_ref(j),0.9*max(height_final)]);
        min_peak_distance_temp                              = min([ceil(min_peak_distance/mean(diff(position_final))),length(height_final)-1]);
        [~, peak_index_final]                               = findpeaks(height_final,'MinpeakDistance', min_peak_distance_temp, 'MinpeakHeight', min_peak_height, 'Sortstr','descend');                                         % Finds peaks in the corrected image to identify different terrace
        peak_index_final                                    = sort(peak_index_final(1:min([ peaks_fit(j), length(peak_index_final)])),'ascend');       % Sorts peaks from smallest index (position) to highest one
        peak_height_final                                   = height_final(peak_index_final);
        peak_position_final                                 = position_final(peak_index_final);
           
        
        if plot_intermediate_steps == 1
            figure(summary_fig)
            % Plots all the histograms with the same axis
            subplot(2, 7, 10)
            axis([min_hist max_hist 0 max_peak_ampl*1.5])
            subplot(2, 7, 11)
            axis([min_hist max_hist 0 max_peak_ampl*1.5])
            subplot(2, 7, 12)
            axis([min_hist max_hist 0 max_peak_ampl*1.5])
            subplot(2, 7, 13)
            axis([min_hist max_hist 0 max_peak_ampl*1.5])
        end
           
        all_images(index, 1:size(images(:,:,J),1), 1:size(images(:,:,J),2), j)                      = images(:,:,J);
        all_images_int(index, 1:size(images(:,:,J),1), 1:size(images(:,:,J),2), j)                  = images_int(:,:,J);

        

%% Computes a final histogram and CDF of the corrected image and fits Gaussians (like before)  Displays the final histogram and fits and saves plots 
        axes(S.ax2)
        %[tok remain]                                    = strtok(Filename{index},'.');
        %file_number                                     = str2double(remain(2:4));
        
            [y1_data, x_data]                           = hist(reshape(images(:,:,J),size(images,1)*size(images,2),1),min(min(images(:,:,J))):(max(max(images(:,:,J)))-min(min(images(:,:,J))))/(histogram_bins-1):max(max(images(:,:,J))));
            y2_data                                     = zeros(size(y1_data,1),1);
            x_data                                      = x_data';
            y1_data                                     = y1_data';
            y1_data                                     = smooth(y1_data,smoothing_level,'loess');
            y1_data                                     = 100*y1_data/sum(y1_data);
            for i                                       = 1:size(y1_data,1)
                y2_data(i,1)                            = sum(y1_data(1:i));
            end
        
            index_low                                   = find(y2_data >= 0.5,1);
            percent_low                                 = x_data(index_low);
            index_high                                  = find(y2_data >= 99.5,1);
            percent_high                                = x_data(index_high);
        if overwrite_xlim(j) == 0 && SymZLim(j) == 1            
            if  max(abs([percent_low,percent_high])) >= 10
                min_z(j)                                    = -10*ceil(max(abs([percent_low,percent_high]))/10);
                max_z(j)                                    =  10*ceil(max(abs([percent_low,percent_high]))/10);
            elseif max(abs([percent_low,percent_high])) < 10 && max(abs([percent_low,percent_high])) >= 1 
                min_z(j)                                    = -1*ceil(max(abs([percent_low,percent_high])));
                max_z(j)                                    =  1*ceil(max(abs([percent_low,percent_high])));
            elseif max(abs([percent_low,percent_high])) < 1 && max(abs([percent_low,percent_high])) >= 0.1
                min_z(j)                                    = -0.1*ceil(max(abs([percent_low,percent_high]))*10);
                max_z(j)                                    =  0.1*ceil(max(abs([percent_low,percent_high]))*10);
            elseif max(abs([percent_low,percent_high])) < 0.1
                min_z(j)                                    = -0.01*ceil(max(abs([percent_low,percent_high]))*100);
                max_z(j)                                    =  0.01*ceil(max(abs([percent_low,percent_high]))*100);
            end
        elseif overwrite_xlim(j) == 0 && SymZLim(j) == 0
            if  max(abs([percent_low,percent_high])) >= 10
                min_z(j)                                    = 10*floor(percent_low/10);
                max_z(j)                                    = 10*ceil(percent_high/10);
            elseif max(abs([percent_low,percent_high])) < 10 && max(abs([percent_low,percent_high])) >= 1 
                min_z(j)                                    = 1*floor(percent_low);
                max_z(j)                                    = 1*ceil(percent_high);
            elseif max(abs([percent_low,percent_high])) < 1 && max(abs([percent_low,percent_high])) >= 0.1
                min_z(j)                                    = 0.1*floor(percent_low*10);
                max_z(j)                                    = 0.1*ceil(percent_high*10);
            elseif max(abs([percent_low,percent_high])) < 0.1
                min_z(j)                                    = 0.01*floor(percent_low*100);
                max_z(j)                                    = 0.01*ceil(percent_high*100);
            end 
        end
        
        
        image_inside_range                              = images(:,:,J);
        image_inside_range((images(:,:,J) < min_z(j)))  = min_z(j);                                                                                                              
        image_inside_range((images(:,:,J) > max_z(j)))  = max_z(j); 
        
        
        im_px_temp                                      = max(size(images(:,:,J)));
        im_grey_temp                                    = (image_inside_range-min_z(j))/(max_z(j)-min_z(j));

        if numel(AspectRatio)>=1
            if AspectRatio(1)==1
                im_grey_temp                            = imresize(im_grey_temp,[im_px_temp,im_px_temp]);
            else
                im_grey_temp                            = imresize(im_grey_temp,[im_px_temp/AspectRatio(1),im_px_temp]);
            end
        else
                im_grey_temp                            = imresize(im_grey_temp,[im_px_temp,im_px_temp]);
        end
        %figure(6); imshow(im_grey_temp);
        imwrite(im_grey_temp,[ImageDir,get(S.baseDirectoryText,'string'),filesep,'Figure PNGS',filesep,channel_info(J).Name,filesep,'grey',filesep,tok,'_',channel_info(J).Name,'(',num2str(j),')','_',num2str(file_number),'_grey.png'],'png','BitDepth',16);

        [y1_data, x_data]                                = hist(reshape(image_inside_range,size(images,1)*size(images,2),1),min_z(j):(max_z(j)-min_z(j))/(histogram_bins-1):max_z(j));
        y2_data                                         = zeros(size(y1_data,1),1);

        x_data                                          = x_data';
        y1_data                                         = y1_data';
        y1_data                                         = smooth(y1_data,smoothing_level,'loess');
        y1_data                                         = 100*y1_data/sum(y1_data);
        for i                                           = 1:size(y1_data,1)
            y2_data(i,1)                                = sum(y1_data(1:i));
        end
        
        [AX,H1,H2]                                      = plotyy(S.ax2,x_data,y1_data,x_data,y2_data,'plot');
        set(AX(1),'YColor','k');
        set(AX(2),'YColor','r');
        axis auto;
        
        set(AX(1),'YLim',[-0.002*ceil(max(y1_data)) 1.002*ceil(max(y1_data))],'YTick',0:ceil(max(y1_data))/10:ceil(max(y1_data)),'YTickLabel',0:ceil(max(y1_data))/10:ceil(max(y1_data)))
        set(AX(2),'YLim',[-0.2 100.2],'YTick',0:10:100,'YTickLabel',0:10:100) 
            axis_lim = [min_z(j),max_z(j)];
            set(AX(1),'XLim',axis_lim(1:2),'XTick',axis_lim(1):(axis_lim(2)-axis_lim(1))/10:axis_lim(2),'XTickLabel',axis_lim(1):(axis_lim(2)-axis_lim(1))/10:axis_lim(2));
            set(AX(2),'XLim',axis_lim(1:2),'XTick',axis_lim(1):(axis_lim(2)-axis_lim(1))/10:axis_lim(2),'XTickLabel',axis_lim(1):(axis_lim(2)-axis_lim(1))/10:axis_lim(2));

        set(AX(1),'yticklabel',sprintf('%0.1f |',get(AX(1),'ytick')'));
        set(AX(2),'yticklabel',sprintf('%0.0f |',get(AX(2),'ytick')'));
        set(get(AX(1),'Ylabel'),'String','% Area','FontSize', FontSize, 'FontName', FontName,'Color','k');
        set(get(AX(2),'Ylabel'),'String','% Below Given Value','FontSize', FontSize, 'FontName', FontName,'Color','r');

        set(H1,'Color','k','LineWidth',2);
        set(H2,'Color','r','LineWidth',2);

        xlabel([channel_info(J).Name,' (',channel_info(J).Unit,')'],'FontSize', FontSize, 'FontName', FontName );
        %title([channel_info(J).Name,'(',num2str(j),')',' ',num2str(file_number)],'FontSize', FontSize*1.5, 'FontName', FontName ); 
        set(AX(1),'FontSize', FontSize, 'FontName', FontName);
        set(AX(2),'FontSize', FontSize, 'FontName', FontName);

        if disp_percent == 1
        percent_val                                     = zeros(length(percent_search),1);
        text_disp                                       =  cell(length(percent_search),1);
        for i                                           = 1:length(percent_search)
            index_height                                = find(y2_data >= percent_search(i),1);
            percent_val(i)                              = x_data(index_height);
            text_disp{i,1}                              = [num2str(percent_search(i)),'% below ',num2str(percent_val(i),'%02.2f'),' ',channel_info(J).Unit];
        end
        else
        end

        x_range                                         = get(AX(1),'XLim'); 
        y_range                                         = get(AX(1),'YLim');
        text(x_range(2) -.02*(x_range(2)-x_range(1)),y_range(2)-.02*(y_range(2)-y_range(1)),text_disp,'FontSize', 0.75*FontSize, 'FontName', FontName,'VerticalAlignment','top','HorizontalAlignment','right' );

        if fit_hist(j) == 1       
            if ceil(min_peak_distance/mean(diff(x_data))) <= 1
               min_peak_prime = 2; 
            elseif ceil(min_peak_distance/mean(diff(x_data))) >= length(y1_data)
               min_peak_prime = length(y1_data) -1;
            else
               min_peak_prime = floor(min_peak_distance/mean(diff(x_data)));
            end
            [peak_height_hist, peak_index_hist]          = findpeaks(y1_data,'MinpeakDistance', min_peak_prime, 'Sortstr','descend'); %min_peak_distance, 'Threshold', peak_threshold, 'Sortstr','descend');                                                                       % Finds peaks in the corrected image to identify different terrace
            
            
            t_hist_lower = zeros(1,3*min([ peaks_fit(j),length(peak_height_hist)])); 
            t_hist_start = zeros(1,3*min([ peaks_fit(j),length(peak_height_hist)])); 
            t_hist_upper = zeros(1,3*min([ peaks_fit(j),length(peak_height_hist)])); 
       for i                                          = 0:min([peaks_fit(j),length(peak_height_hist)])-1                                                                                                    % Loops for the minimum of the number of peaks or 3
            t_hist_lower(3*i+1)                       = max([(1-amplitude_fract)*peak_height_hist(i+1),0.99*min_peak_height]);
            t_hist_lower(3*i+2)                       = x_data(peak_index_hist(i+1))-min([min_peak_distance,(min_spacing_stdev(index,j)+max_spacing_stdev(index,j))/2])/4;
            t_hist_lower(3*i+3)                       = min_spacing_stdev(index,j);
            
            t_hist_upper(3*i+1)                       = max([(1+amplitude_fract)*peak_height_hist(i+1),1.01*min_peak_height]);
            t_hist_upper(3*i+2)                       = x_data(peak_index_hist(i+1))+min([min_peak_distance,(min_spacing_stdev(index,j)+max_spacing_stdev(index,j))/2])/4;
            t_hist_upper(3*i+3)                       = max_spacing_stdev(index,j);
            
            t_hist_start(3*i+1)                       = max([(1-0)*peak_height_hist(i+1),0.99*min_peak_height]);
            t_hist_start(3*i+2)                       = x_data(peak_index_hist(i+1));
            t_hist_start(3*i+3)                       = (min_spacing_stdev(index,j)+max_spacing_stdev(index,j))/2;
            
       end
        clear peak_gaussian_std peak_gaussian_ampl peak_gaussian_pos;
        % Fits the data with the speficied conditions
        t_hist = fitoptions('Method','NonlinearLeastSquares',...                                                                                                                        % Sets the conditions for fitting
                   'Lower',      t_hist_lower,...
                   'Upper',      t_hist_upper,...
                   'Startpoint', t_hist_start,...
                   'MaxIter',    1e2,...
                   'MaxFunEvals',3e2);
        %f_Number_hist = fittype(func_form,  'options' ,t_hist)
        func_form                                   = ['gauss',num2str(min([ peaks_fit(j),length(peak_height_hist)]))];
        f_Number_hist                               = fittype(func_form);
        [gaussian_fit,gaussian_fit_gof]     = fit(  x_data,...
                                                                    y1_data,...
                                                                    f_Number_hist,t_hist);

        hold on
        plot(x_data,gaussian_fit(x_data),'--b','LineWidth',2);
        for i                                           = 1:min(peaks_fit(j),length(peak_height_hist))
        text(1.05*eval(['gaussian_fit.b',num2str(i)]),...
         0.85*eval(['gaussian_fit.a',num2str(i)]),...
         { [num2str(sum(eval(['gaussian_fit.a',num2str(i),'*exp(-(x_data-gaussian_fit.b',num2str(i),').^2/((gaussian_fit.c',num2str(i),')^2))'])),'%02.2f'),'% @'];...
           [num2str(eval(['gaussian_fit.b',num2str(i)]),'%02.2f'),' +- ',num2str(eval(['1/sqrt(2)*gaussian_fit.c',num2str(i)]),'%02.2f'),' ',channel_info(J).Unit]},...
         'FontSize', 0.75*FontSize, 'FontName', FontName,'VerticalAlignment','bottom','HorizontalAlignment','left','color','b' );
        end

        else
        end
        
        hold off;    
        
        fig2 = figure('visible','off');
        [AX,H1,H2]                                      = plotyy(x_data,y1_data,x_data,y2_data,'plot');
        set(AX(1),'YColor','k');
        set(AX(2),'YColor','r');
        axis auto;
        
        set(AX(1),'YLim',[-0.002*ceil(max(y1_data)) 1.002*ceil(max(y1_data))],'YTick',0:ceil(max(y1_data))/10:ceil(max(y1_data)),'YTickLabel',0:ceil(max(y1_data))/10:ceil(max(y1_data)))
        set(AX(2),'YLim',[-0.2 100.2],'YTick',0:10:100,'YTickLabel',0:10:100) 
            axis_lim = [min_z(j),max_z(j)];
            set(AX(1),'XLim',axis_lim(1:2),'XTick',axis_lim(1):(axis_lim(2)-axis_lim(1))/10:axis_lim(2),'XTickLabel',axis_lim(1):(axis_lim(2)-axis_lim(1))/10:axis_lim(2));
            set(AX(2),'XLim',axis_lim(1:2),'XTick',axis_lim(1):(axis_lim(2)-axis_lim(1))/10:axis_lim(2),'XTickLabel',axis_lim(1):(axis_lim(2)-axis_lim(1))/10:axis_lim(2));

        set(AX(1),'yticklabel',sprintf('%0.1f |',get(AX(1),'ytick')'));
        set(AX(2),'yticklabel',sprintf('%0.0f |',get(AX(2),'ytick')'));
        set(get(AX(1),'Ylabel'),'String','% Area','FontSize', FontSize, 'FontName', FontName,'Color','k');
        set(get(AX(2),'Ylabel'),'String','% Below Given Value','FontSize', FontSize, 'FontName', FontName,'Color','r');

        set(H1,'Color','k','LineWidth',2);
        set(H2,'Color','r','LineWidth',2);

        xlabel([channel_info(J).Name,' (',channel_info(J).Unit,')'],'FontSize', FontSize, 'FontName', FontName );
        %title([channel_info(J).Name,'(',num2str(j),')',' ',num2str(file_number)],'FontSize', FontSize*1.5, 'FontName', FontName ); 
        set(AX(1),'FontSize', FontSize, 'FontName', FontName);
        set(AX(2),'FontSize', FontSize, 'FontName', FontName);

        if disp_percent == 1
        percent_val                                     = zeros(length(percent_search),1);
        text_disp                                       =  cell(length(percent_search),1);
        for i                                           = 1:length(percent_search)
            index_height                                = find(y2_data >= percent_search(i),1);
            percent_val(i)                              = x_data(index_height);
            text_disp{i,1}                              = [num2str(percent_search(i)),'% below ',num2str(percent_val(i),'%02.2f'),' ',channel_info(J).Unit];
        end
        else
        end

        x_range                                         = get(AX(1),'XLim'); 
        y_range                                         = get(AX(1),'YLim');
        text(x_range(2) -.02*(x_range(2)-x_range(1)),y_range(2)-.02*(y_range(2)-y_range(1)),text_disp,'FontSize', 0.75*FontSize, 'FontName', FontName,'VerticalAlignment','top','HorizontalAlignment','right' );

        if fit_hist(j) == 1       
            [gaussian_fit, gaussian_gof, n_peaks,~,~]       = fit_multi_gauss(image_inside_range,index,j,S,min_spacing_stdev_user,max_spacing_stdev_user,amplitude_fract,smoothing_level);
            hold on
            plot(x_data,gaussian_fit(x_data),'--b','LineWidth',2);
        for i                                           = 1:n_peaks
            text(1.05*eval(['gaussian_fit.b',num2str(i)]),...
            0.85*eval(['gaussian_fit.a',num2str(i)]),...
            {   [num2str(sum(eval(['gaussian_fit.a',num2str(i),'*exp(-(x_data-gaussian_fit.b',num2str(i),').^2/((gaussian_fit.c',num2str(i),')^2))'])),'%02.2f'),'% @'];...
                [num2str(eval(['gaussian_fit.b',num2str(i)]),'%02.2f'),' +- ',num2str(eval(['1/sqrt(2)*gaussian_fit.c',num2str(i)]),'%02.2f'),' ',channel_info(J).Unit]},...
            'FontSize', 0.75*FontSize, 'FontName', FontName,'VerticalAlignment','bottom','HorizontalAlignment','left','color','b' );
        end

        else
        end
        set(gcf, 'PaperPositionMode', 'auto'); print(fig2, '-loose',  '-dpng' ,  [ImageDir,get(S.baseDirectoryText,'string'),filesep,'Figure PNGS',filesep,channel_info(J).Name,filesep,'hist',filesep,tok,'_',channel_info(J).Name,'(',num2str(j),')','_',num2str(file_number),'_hist_cdf.png']);
        pause(0.001) % just to get a good display...
        close(fig2);
        
        %S.min_spacing_stdev_user(j) = 1/sqrt(2)*min_spacing_stdev(index,j);
        %S.max_spacing_stdev_user(j) = 1/sqrt(2)*max_spacing_stdev(index,j);
        
%% Plots the final corrected image with user set color and scale bars and saves the output    
        %axes(S.ax1)
        ScanZ                                       = max_z(j)-min_z(j);                                                                                                                    % Sets the user defined data scale for each channel
        set(S.AspectRatio,'string',num2str(AspectRatio(1)));
        if numel(AspectRatio)>=1
        if AspectRatio(1)==1 
            imshow(imresize(images(:,:,J),[max(size(images(:,:,J))),max(size(images(:,:,J)))]),[min_z(j),max_z(j)],'Parent',S.ax1);                                      % Generates a new Figure with the name of the correct channel,  Resizes the image to a square the size of the largest dimension.  This is useful when using nonsquare pixels.  Sets the display range from the min to the max      
        else
            imshow(imresize(images(:,:,J),[max(size(images(:,:,J)))/AspectRatio(1),max(size(images(:,:,J)))]),[min_z(j),max_z(j)],'Parent',S.ax1);                                      % Generates a new Figure with the name of the correct channel,  Resizes the image to a square the size of the largest dimension.  This is useful when using nonsquare pixels.  Sets the display range from the min to the max      
        end
        else
            imshow(imresize(images(:,:,J),[max(size(images(:,:,J))),max(size(images(:,:,J)))]),[min_z(j),max_z(j)],'Parent',S.ax1);                                      % Generates a new Figure with the name of the correct channel,  Resizes the image to a square the size of the largest dimension.  This is useful when using nonsquare pixels.  Sets the display range from the min to the max      
        end
        % Loads the Georg approved colormap
        color_string    = get(S.ColorBarSelect, 'string');
        color_value     = get(S.ColorBarSelect, 'value');
        switch color_string{color_value}                                                                                                                                                   
            case 'Autumn'                                                                                                                                                        
                colormap(autumn);
            case 'Bone'                                                                                                                                                        
                colormap(bone);
            case 'ColorCube'                                                                                                                                                        
                colormap(colorcube);
            case 'Cool'                                                                                                                                                        
                colormap(cool);
            case 'Copper'                                                                                                                                                        
                colormap(copper);
            case 'Flag'                                                                                                                                                        
                colormap(flag);
            case 'Gray'                                                                                                                                                        
                colormap(gray);
            case 'Hot'                                                                                                                                                        
                colormap(hot);
            case 'HSV'                                                                                                                                                        
                colormap(hsv);
            case 'Jet'                                                                                                                                                        
                colormap(jet);
            case 'Lines'                                                                                                                                                        
                colormap(lines);
            case 'Pink'                                                                                                                                                        
                colormap(pink);
            case 'Prism'                                                                                                                                                        
                colormap(prism);
            case 'Spring'                                                                                                                                                        
                colormap(spring);
            case 'Summer'                                                                                                                                                        
                colormap(summer);
            case 'Winter'                                                                                                                                                        
                colormap(winter);
            case 'Sky'
                load('Sky','mycmap_sky') 
                colormap(mycmap_sky);
            case 'NanoBrown'
                load('NanoBrown','mycmap_nanobrown') 
                colormap(mycmap_nanobrown);
        end
        
            % Sets the colormap
            hcb = colorbar('peer',S.ax1,'YTick',min_z(j):ScanZ/10:max_z(j),...
                          'YTickLabel',{            [num2str(min_z(j)+0*ScanZ/10,'%0.2f'),' ', channel_info(J).Unit],...                                                                    % Inserts a color bar.  Sets the 1st tick with approriate labels
                                                    [num2str(min_z(j)+1*ScanZ/10,'%0.2f'),' ', channel_info(J).Unit],...                                                                    % Sets the 2nd tick with approriate labels
                                                    [num2str(min_z(j)+2*ScanZ/10,'%0.2f'),' ', channel_info(J).Unit],...                                                                    % Sets the 3rd tick with approriate labels
                                                    [num2str(min_z(j)+3*ScanZ/10,'%0.2f'),' ', channel_info(J).Unit],...                                                                    % Sets the 4th tick with approriate labels
                                                    [num2str(min_z(j)+4*ScanZ/10,'%0.2f'),' ', channel_info(J).Unit],...                                                                    % Sets the 5th tick with approriate labels
                                                    [num2str(min_z(j)+5*ScanZ/10,'%0.2f'),' ', channel_info(J).Unit],...                                                                    % Sets the 6th tick with approriate labels
                                                    [num2str(min_z(j)+6*ScanZ/10,'%0.2f'),' ', channel_info(J).Unit],...                                                                    % Sets the 7th tick with approriate labels
                                                    [num2str(min_z(j)+7*ScanZ/10,'%0.2f'),' ', channel_info(J).Unit],... 
                                                    [num2str(min_z(j)+8*ScanZ/10,'%0.2f'),' ', channel_info(J).Unit],...  
                                                    [num2str(min_z(j)+9*ScanZ/10,'%0.2f'),' ', channel_info(J).Unit],...                                                                    % Sets the 8th tick with approriate labels
                                                    [num2str(min_z(j)+10*ScanZ/10,'%0.2f'),' ', channel_info(J).Unit]},...                                                                  % Sets the 9th tick with approriate labels
                                                    'FontSize', FontSize, 'FontName', FontName);                                                                                            % Sets the font and size for the color bar
            set(hcb,'YTickMode','manual','FontSize', FontSize, 'FontName', FontName);                                                                                                       % Apply the font to the colorbar


        %This plots the integral scale bar.  It works...  It's not all my code.
        DistFactor                                  = 0.05;                                                                                                                                 % Scalebar height
        Length                                      = ScaleBar;                                                                                                                             % User set scalebar length
        Pos                                         = [0.5*max(size(images(:,:,J))),0.95*max(size(images(:,:,J)))];                                                                         % positions scale bar
        Scale                                       = ScanSize/(size(images,2)*(1+crop_fraction));                                                                                                              % Image scale
        UnitsName                                   = ' nm';                                                                                                                                % Units for the scale bar
        NextPlot                                    = get(gca,'NextPlot');                                                                                                              
        hold on;

        XLim                                        = get(gca,'XLim');
        YLim                                        = get(gca,'YLim');
        Xdiff                                       = abs(diff(XLim));
        Ydiff                                       = abs(diff(YLim));

        LineX                                       = Pos(1) + 0.5.*Length./Scale.*[-1;+1];
        LineY                                       = Pos(2).*[+1;+1];
        DistXdir                                    = 0;
        DistYdir                                    = -1;

     
        %--- plot line ---
        plot(LineX,LineY,'w-','LineWidth',2);


        %--- plot text ---
        DistX                                       = DistXdir.*DistFactor.*Xdiff;
        DistY                                       = DistYdir.*DistFactor.*Ydiff;

        Htext                                       = text(Pos(1)+DistX,Pos(2)+DistY,sprintf('%5.1f %s',Length,UnitsName));
        set(Htext,'HorizontalAlignment','center','Color', 'w', 'FontSize', FontSize, 'FontName', FontName);
        set(gca,'XLim',XLim);
        set(gca,'YLim',YLim);
        set(gca,'NextPlot',NextPlot);
        set(gca, 'XTickMode', 'manual');
        hold off;
            
        fig3 = figure('visible','off');
        if numel(AspectRatio)>=1
        if AspectRatio(1)==1 
            imshow(imresize(images(:,:,J),[max(size(images(:,:,J))),max(size(images(:,:,J)))]),[min_z(j),max_z(j)]);                                      % Generates a new Figure with the name of the correct channel,  Resizes the image to a square the size of the largest dimension.  This is useful when using nonsquare pixels.  Sets the display range from the min to the max      
        else
            imshow(imresize(images(:,:,J),[max(size(images(:,:,J)))/AspectRatio(1),max(size(images(:,:,J)))]),[min_z(j),max_z(j)]);                                      % Generates a new Figure with the name of the correct channel,  Resizes the image to a square the size of the largest dimension.  This is useful when using nonsquare pixels.  Sets the display range from the min to the max      
        end
        else
            imshow(imresize(images(:,:,J),[max(size(images(:,:,J))),max(size(images(:,:,J)))]),[min_z(j),max_z(j)]);                                      % Generates a new Figure with the name of the correct channel,  Resizes the image to a square the size of the largest dimension.  This is useful when using nonsquare pixels.  Sets the display range from the min to the max      
        end
       % Loads the Georg approved colormap
        color_string    = get(S.ColorBarSelect, 'string');
        color_value     = get(S.ColorBarSelect, 'value');
        switch color_string{color_value}                                                                                                                                                   
            case 'Autumn'                                                                                                                                                        
                colormap(autumn);
            case 'Bone'                                                                                                                                                        
                colormap(bone);
            case 'ColorCube'                                                                                                                                                        
                colormap(colorcube);
            case 'Cool'                                                                                                                                                        
                colormap(cool);
            case 'Copper'                                                                                                                                                        
                colormap(copper);
            case 'Flag'                                                                                                                                                        
                colormap(flag);
            case 'Gray'                                                                                                                                                        
                colormap(gray);
            case 'Hot'                                                                                                                                                        
                colormap(hot);
            case 'HSV'                                                                                                                                                        
                colormap(hsv);
            case 'Jet'                                                                                                                                                        
                colormap(jet);
            case 'Lines'                                                                                                                                                        
                colormap(lines);
            case 'Pink'                                                                                                                                                        
                colormap(pink);
            case 'Prism'                                                                                                                                                        
                colormap(prism);
            case 'Spring'                                                                                                                                                        
                colormap(spring);
            case 'Summer'                                                                                                                                                        
                colormap(summer);
            case 'Winter'                                                                                                                                                        
                colormap(winter);
            case 'Sky'
                load('Sky','mycmap_sky') 
                colormap(mycmap_sky);
            case 'NanoBrown'
                load('NanoBrown','mycmap_nanobrown') 
                colormap(mycmap_nanobrown);
        end
        
disp_color_bar      = get(S.disp_color_bar, 'value');
if disp_color_bar == 1
            hcb = colorbar('YTick',min_z(j):ScanZ/10:max_z(j),...
                          'YTickLabel',{            [num2str(min_z(j)+0*ScanZ/10,'%0.2f'),' ', channel_info(J).Unit],...                                                                    % Inserts a color bar.  Sets the 1st tick with approriate labels
                                                    [num2str(min_z(j)+1*ScanZ/10,'%0.2f'),' ', channel_info(J).Unit],...                                                                    % Sets the 2nd tick with approriate labels
                                                    [num2str(min_z(j)+2*ScanZ/10,'%0.2f'),' ', channel_info(J).Unit],...                                                                    % Sets the 3rd tick with approriate labels
                                                    [num2str(min_z(j)+3*ScanZ/10,'%0.2f'),' ', channel_info(J).Unit],...                                                                    % Sets the 4th tick with approriate labels
                                                    [num2str(min_z(j)+4*ScanZ/10,'%0.2f'),' ', channel_info(J).Unit],...                                                                    % Sets the 5th tick with approriate labels
                                                    [num2str(min_z(j)+5*ScanZ/10,'%0.2f'),' ', channel_info(J).Unit],...                                                                    % Sets the 6th tick with approriate labels
                                                    [num2str(min_z(j)+6*ScanZ/10,'%0.2f'),' ', channel_info(J).Unit],...                                                                    % Sets the 7th tick with approriate labels
                                                    [num2str(min_z(j)+7*ScanZ/10,'%0.2f'),' ', channel_info(J).Unit],... 
                                                    [num2str(min_z(j)+8*ScanZ/10,'%0.2f'),' ', channel_info(J).Unit],...  
                                                    [num2str(min_z(j)+9*ScanZ/10,'%0.2f'),' ', channel_info(J).Unit],...                                                                    % Sets the 8th tick with approriate labels
                                                    [num2str(min_z(j)+10*ScanZ/10,'%0.2f'),' ', channel_info(J).Unit]},...                                                                  % Sets the 9th tick with approriate labels
                                                    'FontSize', FontSize, 'FontName', FontName);                                                                                            % Sets the font and size for the color bar
            set(hcb,'YTickMode','manual','FontSize', FontSize, 'FontName', FontName);                                                                                                       % Apply the font to the colorbar
else
end

disp_scale_bar      = get(S.disp_scale_bar, 'value');
if disp_scale_bar == 1
        %This plots the integral scale bar.  It works...  It's not all my code.
        DistFactor                                  = 0.05;                                                                                                                                 % Scalebar height
        Length                                      = ScaleBar;                                                                                                                             % User set scalebar length
        Pos                                         = [0.5*max(size(images(:,:,J))),0.95*max(size(images(:,:,J)))];                                                                         % positions scale bar
        Scale                                       = ScanSize/(size(images,2)*(1+crop_fraction));                                                                                                              % Image scale
        UnitsName                                   = ' nm';                                                                                                                                % Units for the scale bar
        NextPlot                                    = get(gca,'NextPlot');                                                                                                              
        hold on;

        XLim                                        = get(gca,'XLim');
        YLim                                        = get(gca,'YLim');
        Xdiff                                       = abs(diff(XLim));
        Ydiff                                       = abs(diff(YLim));

        LineX                                       = Pos(1) + 0.5.*Length./Scale.*[-1;+1];
        LineY                                       = Pos(2).*[+1;+1];
        DistXdir                                    = 0;
        DistYdir                                    = -1;

     
        %--- plot line ---
        plot(LineX,LineY,'w-','LineWidth',2);


        %--- plot text ---
        DistX                                       = DistXdir.*DistFactor.*Xdiff;
        DistY                                       = DistYdir.*DistFactor.*Ydiff;

        Htext                                       = text(Pos(1)+DistX,Pos(2)+DistY,sprintf('%5.1f %s',Length,UnitsName));
        set(Htext,'HorizontalAlignment','center','Color', 'w', 'FontSize', FontSize, 'FontName', FontName);
        set(gca,'XLim',XLim);
        set(gca,'YLim',YLim);
        set(gca,'NextPlot',NextPlot);
        set(gca, 'XTickMode', 'manual');
else
end
        hold off;
        set(gcf, 'PaperPositionMode', 'auto'); print(fig3,['-r',num2str(floor(get(0,'ScreenPixelsPerInch')*1.1))], '-dpng', [ImageDir,get(S.baseDirectoryText,'string'),filesep,'Figure PNGS',filesep,channel_info(J).Name,filesep,tok,'_',channel_info(J).Name,'(',num2str(j),')','_',num2str(file_number),'.png']);                                   % Saves the images.  I'm not sure if i dig the naming just yet.  I'll deal with it later
        pause(0.001) % just to get a good display...
        close(fig3);
        
         if S.processAll  == 0     % If only process one image: save the final image and raw histogram for display
            final_images(:,:,J) = images(:,:,J);
         else
          	all_images(index, :, :, j)            = images(:,:,J);
         end    
   pause(0.001) % just to get a good display...
   
% %%  Save the Time and Height Information
%         if peaks_fit(j) >= 2
%             if index<= 2
%                 Image_Time_File = [ImageDir,get(S.baseDirectoryText,'string'),filesep,'Image_Time_Height.txt'];
%                 gid = fopen(Image_Time_File, 'a');
%                 fprintf(gid, [  'File Name','\t',...
%                                 'File Number','\t',...
%                                 'File Time','\t',...
%                                 'Height 1','\t',...
%                                 'StDev 1','\t',...
%                                 'Height 2','\t',...
%                                 'StDev 2','\n'],...
%                                 'char');
%                             
%                 
%                 fprintf(gid, [      tok,'\t',...
%                                     num2str(file_number,'%0.3f'),'\t',...
%                                     num2str(Time,'%0.3f'),'\t',...
%                                     num2str(gaussian_fit.b1,'%0.3f'),'\t',...
%                                     num2str(1/sqrt(2)*gaussian_fit.c1,'%0.3f'),'\t',...
%                                     num2str(gaussian_fit.b2,'%0.3f'),'\t',...
%                                     num2str(1/sqrt(2)*gaussian_fit.c2,'%0.3f'),'\n'],...
%                                     'char');
% 
%                 fclose(gid);
%             else
%                 gid = fopen(Image_Time_File, 'a');
%                 fprintf(gid, [  tok,'\t',...
%                                     num2str(file_number,'%0.3f'),'\t',...
%                                     num2str(Time,'%0.3f'),'\t',...
%                                     num2str(gaussian_fit.b1,'%0.3f'),'\t',...
%                                     num2str(1/sqrt(2)*gaussian_fit.c1,'%0.3f'),'\t',...
%                                     num2str(gaussian_fit.b2,'%0.3f'),'\t',...
%                                     num2str(1/sqrt(2)*gaussian_fit.c2,'%0.3f'),'\n'],...
%                                     'char');
%                 fclose(gid);
%             end
%             
% 
%          switch char(channel_name{J})                                                                                                                                                   % Sets Units according to recorded channel
%             case 'Height'           
%                 if index==1
%                     mkdir([ImageDir,get(S.baseDirectoryText,'string'),filesep,'Times',filesep]); 
%                 else
%                 end
%                 
%                 Line_Time_File = [ImageDir,get(S.baseDirectoryText,'string'),filesep,'Times',filesep,tok,'_',channel_info(J).Name,'(',num2str(j),')','_',num2str(file_number),'.txt'];
%                 gid = fopen(Line_Time_File, 'w');
%                 fprintf(gid, [  'Time','\t',...
%                                 'Height Difference','\t',...
%                                 'Error In Quadrature','\n'],...
%                                 'char');
%                 fclose(gid);
%                   
%                 Growth_Data = zeros(size(images(:,:,J),1),3);
% %                 disp(['Num of Lines ',num2str(size(images(:,:,J),1))])
% %                 disp(['Line Rate ',num2str(Scan_Rate)])
% %                 disp(['Final Time ',datestr(datenum(Time,'HH:MM:SS AM ddd mmm dd yyyy'),'HH:MM:SS.FFF')])
% %                 disp(['Start Time ',datestr(datenum(Time,'HH:MM:SS AM ddd mmm dd yyyy')-size(images(:,:,J),1)/Scan_Rate/60/60/24,'HH:MM:SS.FFF')])
%                  
%                 
%                 for i = 1:size(images(:,:,J),1)    
%                     [y1_data_temp x_data_temp]  = hist(image_inside_range(i,:),min_z(j):4*(max_z(j)-min_z(j))/(histogram_bins-1):max_z(j));
%                     y1_data_temp                = y1_data_temp';
%                     y1_data_temp                = 100*y1_data_temp/sum(y1_data_temp);
%                     x_data_temp                 = x_data_temp';
%                 
%                     if ceil(min_peak_distance/mean(diff(x_data_temp))) <= 1
%                         min_peak_prime = 2; 
%                     elseif ceil(min_peak_distance/mean(diff(x_data_temp))) >= length(y1_data_temp)
%                         min_peak_prime = length(y1_data_temp) -1;
%                     else
%                         min_peak_prime = ceil(min_peak_distance/mean(diff(x_data_temp)));
%                     end
%                     [peak_height_hist_temp peak_index_hist_temp]          = findpeaks(y1_data_temp,'MinpeakDistance', min_peak_prime, 'Sortstr','descend'); %min_peak_distance, 'Threshold', peak_threshold, 'Sortstr','descend');                                                                       % Finds peaks in the corrected image to identify different terrace
% 
%                     t_hist_lower = zeros(1,3*min([ peaks_fit(j),length(peak_height_hist_temp)])); 
%                     t_hist_start = zeros(1,3*min([ peaks_fit(j),length(peak_height_hist_temp)])); 
%                     t_hist_upper = zeros(1,3*min([ peaks_fit(j),length(peak_height_hist_temp)])); 
%                        for ii                                          = 0:min([peaks_fit(j),length(peak_height_hist_temp)])-1                                                                                                    % Loops for the minimum of the number of peaks or 3
%                             t_hist_lower(3*ii+1)                       = max([(1-amplitude_fract)*peak_height_hist_temp(ii+1),0.99*min_peak_height]);
%                             t_hist_lower(3*ii+2)                       = x_data_temp(peak_index_hist_temp(ii+1))-min([min_peak_distance,(min_spacing_stdev(index,j)+max_spacing_stdev(index,j))/2])/4;
%                             t_hist_lower(3*ii+3)                       = min_spacing_stdev(index,j);
% 
%                             t_hist_upper(3*ii+1)                       = max([(1+amplitude_fract)*peak_height_hist_temp(ii+1),1.01*min_peak_height]);
%                             t_hist_upper(3*ii+2)                       = x_data_temp(peak_index_hist_temp(ii+1))+min([min_peak_distance,(min_spacing_stdev(index,j)+max_spacing_stdev(index,j))/2])/4;
%                             t_hist_upper(3*ii+3)                       = max_spacing_stdev(index,j);
% 
%                             t_hist_start(3*ii+1)                       = max([(1-0)*peak_height_hist_temp(ii+1),0.99*min_peak_height]);
%                             t_hist_start(3*ii+2)                       = x_data_temp(peak_index_hist_temp(ii+1));
%                             t_hist_start(3*ii+3)                       = (min_spacing_stdev(index,j)+max_spacing_stdev(index,j))/2;
% 
%                        end
%                     t_hist  = fitoptions(   'Method','NonlinearLeastSquares',...                                                                                                                        % Sets the conditions for fitting
%                                             'Lower',      t_hist_lower,...
%                                             'Upper',      t_hist_upper,...
%                                             'Startpoint', t_hist_start,...
%                                             'MaxIter',    1e2,...
%                                             'MaxFunEvals',3e2);
%                     func_form                                   = ['gauss',num2str(min([ peaks_fit(j),length(peak_height_hist_temp)]))];
%                     f_Number_hist                               = fittype(func_form);
%                        
%                        
%                     [gaussian_fit_temp,gaussian_fit_temp_gof] = fit( x_data_temp,...
%                                                                                  y1_data_temp,...
%                                                                                  f_Number_hist,t_hist);
%                     
% 
%                     
%                     if Direction == 0
%                         Growth_Data(i,1) = datenum(Time,'HH:MM:SS AM ddd mmm dd yyyy') -(i-1)/Scan_Rate/60/60/24;
%                     else
%                         Growth_Data(i,1) = datenum(Time,'HH:MM:SS AM ddd mmm dd yyyy') -(size(images(:,:,J),1)-i+1)/Scan_Rate/60/60/24;
%                     end
%                     
%                     try
%                         Growth_Data(i,2) = gaussian_fit_temp.b2-gaussian_fit_temp.b1;
%                         Growth_Data(i,3) = sqrt((1/sqrt(2)*gaussian_fit_temp.c1)^2+(1/sqrt(2)*gaussian_fit_temp.c2)^2);
%                     catch
%                         Growth_Data(i,2) = NaN;
%                         Growth_Data(i,3) = NaN;
%                     end
%                 end
%                 dlmwrite(Line_Time_File, Growth_Data, 'delimiter', '\t','precision', 13, '-append')
%                 
%          end
%         
%         
%         else
%         end
%         
%         
    end   % end of "for j" loop
       if S.processAll  == 0     % If only process one image: save the final image and raw histogram for display
            save([ImageDir,'Nano6_variables.mat'], 'channel_info', 'Filename', ...            % Saves only variables needed for plotting to be faster
                'final_images', 'raw_images', 'med_corr_1_images','ini_tilt_images', 'poly_flat_1_images', 'med_corr_2_images', 'poly_flat_2_images', ...
                'min_spacing_stdev', 'max_spacing_stdev', 'mycmap_sky', 'min_z', 'max_z', 'histogram_bins', 'ScanSize', ...
                'smoothing_level', 'min_hist', 'max_hist', 'std_est');
            break;
       end
end

